/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.localization.stringeditor.editor.operations;

import java.io.IOException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tml.common.utilities.BasePlugin;
import org.eclipse.tml.localization.stringeditor.datatype.ColumnInfo;
import org.eclipse.tml.localization.stringeditor.editor.StringEditorPart;
import org.eclipse.tml.localization.stringeditor.editor.operations.EditorOperation;

public class RevertColumnToSavedStateOperation
extends EditorOperation {
    private final ColumnInfo actualState;
    private ColumnInfo savedState = null;
    boolean changedColumn = false;

    public RevertColumnToSavedStateOperation(String label, StringEditorPart editor, ColumnInfo actual) {
        super(label, editor);
        this.actualState = actual;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        try {
            this.getEditorInput().revert(this.actualState.getId());
        }
        catch (IOException e) {
            BasePlugin.logError((String)("Error reverting column: " + this.actualState.getId()), (Throwable)e);
        }
        this.savedState = new ColumnInfo(this.actualState.getId(), this.actualState.getTooltip(), this.getEditorInput().getValues(this.actualState.getId()), this.actualState.canRemove());
        return this.redo(monitor, info);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.getModel().removeColumn(this.actualState.getId());
        this.getModel().addColumn(this.savedState);
        this.changedColumn = this.getEditor().unmarkColumnAsChanged(this.actualState.getId());
        this.getEditor().getEditorViewer().refresh();
        return Status.OK_STATUS;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.getModel().removeColumn(this.savedState.getId());
        this.getModel().addColumn(this.actualState);
        if (this.changedColumn) {
            this.getEditor().markColumnAsChanged(this.actualState.getId());
        }
        this.getEditor().getEditorViewer().refresh();
        return Status.OK_STATUS;
    }
}

