/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.protocol;

import java.util.Collection;
import java.util.Map;
import org.eclipse.tml.protocol.exceptions.MalformedProtocolExtensionException;
import org.eclipse.tml.protocol.internal.model.PluginProtocolModel;
import org.eclipse.tml.protocol.lib.IProtocolExceptionHandler;
import org.eclipse.tml.protocol.lib.IProtocolHandshake;
import org.eclipse.tml.protocol.lib.ProtocolActionDelegate;
import org.eclipse.tml.protocol.lib.ProtocolHandle;
import org.eclipse.tml.protocol.lib.ProtocolMessage;
import org.eclipse.tml.protocol.lib.msgdef.ProtocolMsgDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginProtocolActionDelegate {
    public static ProtocolHandle requestStartProtocolAsClient(String protocolId, IProtocolExceptionHandler exceptionHandler, String host, int port, Map<String, Object> parameters) throws MalformedProtocolExtensionException {
        PluginProtocolModel model = PluginProtocolModel.getInstance();
        Map<Long, ProtocolMsgDefinition> allMessages = model.getAllProtocolMessages(protocolId);
        Collection<String> incomingMessages = model.getServerMessages(protocolId);
        Collection<String> outgoingMessages = model.getClientMessages(protocolId);
        IProtocolHandshake protocolInitializer = model.getProtocolInit(protocolId);
        boolean isBigEndianProtocol = model.isBigEndianProtocol(protocolId);
        return ProtocolActionDelegate.requestStartProtocolAsClient(allMessages, incomingMessages, outgoingMessages, protocolInitializer, exceptionHandler, isBigEndianProtocol, host, port, parameters);
    }

    public static ProtocolHandle requestStartProtocolAsServer(String protocolId, int serverPort, IProtocolExceptionHandler exceptionHandler) throws MalformedProtocolExtensionException {
        PluginProtocolModel model = PluginProtocolModel.getInstance();
        Map<Long, ProtocolMsgDefinition> allMessages = model.getAllProtocolMessages(protocolId);
        Collection<String> incomingMessages = model.getClientMessages(protocolId);
        Collection<String> outgoingMessages = model.getServerMessages(protocolId);
        IProtocolHandshake protocolInitializer = model.getProtocolInit(protocolId);
        boolean isBigEndianProtocol = model.isBigEndianProtocol(protocolId);
        return ProtocolActionDelegate.requestStartProtocolAsServer(serverPort, allMessages, incomingMessages, outgoingMessages, protocolInitializer, exceptionHandler, isBigEndianProtocol);
    }

    public static void requestStopProtocol(ProtocolHandle handle) {
        ProtocolActionDelegate.requestStopProtocol(handle);
    }

    public static void requestRestartProtocol(ProtocolHandle handle) {
        ProtocolActionDelegate.requestRestartProtocol(handle);
    }

    public static void sendMessageToServer(ProtocolHandle handle, ProtocolMessage message) {
        ProtocolActionDelegate.sendMessageToServer(handle, message);
    }

    public static boolean isProtocolRunning(ProtocolHandle handle) {
        return ProtocolActionDelegate.isProtocolRunning(handle);
    }
}

