/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device.ui.wizard;

import java.util.ArrayList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tml.framework.device.DevicePlugin;
import org.eclipse.tml.framework.device.factory.DeviceTypeRegistry;
import org.eclipse.tml.framework.device.factory.InstanceRegistry;
import org.eclipse.tml.framework.device.internal.model.MobileDeviceType;
import org.eclipse.tml.framework.device.model.AbstractMobileInstance;
import org.eclipse.tml.framework.device.model.IDeviceType;
import org.eclipse.tml.framework.device.ui.DeviceUIResources;
import org.eclipse.tml.framework.device.ui.wizard.NewDeviceWizard;

public class DefaultDeviceTypeWizardPage
extends WizardPage {
    private static final String PROPERTY_ICON = "icon";
    private String instanceName = "";
    private MobileDeviceType currentDeviceType;
    private TreeViewer deviceTypesTreeViewer;

    protected DefaultDeviceTypeWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    protected DefaultDeviceTypeWizardPage(String pageName) {
        super(pageName);
        this.setTitle(DeviceUIResources.TML_Default_Device_Type_Wizard_Page_title);
        this.setMessage(DeviceUIResources.TML_Default_Device_Type_Wizard_Page_message);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        container.setFont(parent.getFont());
        Label label = new Label(container, 0);
        label.setText(DeviceUIResources.TML_Default_Device_Type_Wizard_Page_name);
        label.setFont(container.getFont());
        final Text nameText = new Text(container, 2048);
        GridData gd = new GridData(768);
        nameText.setLayoutData((Object)gd);
        nameText.setFont(container.getFont());
        nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InstanceRegistry registry = InstanceRegistry.getInstance();
                String name = nameText.getText();
                String errorMessage = null;
                DefaultDeviceTypeWizardPage.this.instanceName = "";
                if (name != null && !name.equals("")) {
                    if (registry.getInstancesByName(name).size() != 0) {
                        errorMessage = DeviceUIResources.TML_Emulator_Wizard_Project_Description_Duplicated_Error;
                    } else if (!AbstractMobileInstance.validName((String)name)) {
                        errorMessage = DeviceUIResources.TML_Instance_Name_Invalid_Error;
                    } else {
                        DefaultDeviceTypeWizardPage.this.instanceName = name;
                    }
                }
                DefaultDeviceTypeWizardPage.this.setErrorMessage(errorMessage);
                DefaultDeviceTypeWizardPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.createDeviceTypesArea(container);
        this.setControl((Control)container);
    }

    public boolean isPageComplete() {
        if (this.getErrorMessage() != null) {
            return false;
        }
        return this.instanceName.trim() != "" && this.currentDeviceType != null;
    }

    private void createDeviceTypesArea(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(DeviceUIResources.TML_Default_Device_Type_Wizard_Page_deviceTypes);
        label.setFont(parent.getFont());
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.deviceTypesTreeViewer = new TreeViewer(parent);
        this.deviceTypesTreeViewer.setContentProvider((IContentProvider)new DeviceTypesContentProvider());
        this.deviceTypesTreeViewer.setLabelProvider((IBaseLabelProvider)new DeviceTypesLabelProvider());
        this.deviceTypesTreeViewer.setInput((Object)this);
        this.deviceTypesTreeViewer.addFilter((ViewerFilter)new AbstractDeviceTypeViewerFilter());
        this.deviceTypesTreeViewer.expandAll();
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gd.verticalSpan = 2;
        this.deviceTypesTreeViewer.getControl().setLayoutData((Object)gd);
        this.deviceTypesTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object firstElement;
                ISelection selection = DefaultDeviceTypeWizardPage.this.deviceTypesTreeViewer.getSelection();
                if (selection instanceof StructuredSelection && (firstElement = ((StructuredSelection)selection).getFirstElement()) instanceof MobileDeviceType) {
                    DefaultDeviceTypeWizardPage.this.currentDeviceType = (MobileDeviceType)firstElement;
                    IWizard wizard = DefaultDeviceTypeWizardPage.this.getWizard();
                    if (wizard instanceof NewDeviceWizard) {
                        ((NewDeviceWizard)wizard).setCurrentDeviceTypeId(DefaultDeviceTypeWizardPage.this.currentDeviceType.getId());
                    }
                }
                DefaultDeviceTypeWizardPage.this.getWizard().getContainer().updateButtons();
            }
        });
    }

    public String getInstanceName() {
        return this.instanceName.trim();
    }

    public MobileDeviceType getDeviceType() {
        return this.currentDeviceType;
    }

    class AbstractDeviceTypeViewerFilter
    extends ViewerFilter {
        AbstractDeviceTypeViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return !(element instanceof IDeviceType) || !((IDeviceType)element).isAbstract();
        }
    }

    class DeviceTypesContentProvider
    implements ITreeContentProvider {
        DeviceTypesContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            ArrayList children = new ArrayList();
            if (parentElement instanceof DefaultDeviceTypeWizardPage) {
                return DeviceTypeRegistry.getInstance().getDeviceTypes().toArray();
            }
            return children.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getElements(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class DeviceTypesLabelProvider
    extends LabelProvider {
        DeviceTypesLabelProvider() {
        }

        public Image getImage(Object element) {
            MobileDeviceType item;
            if (element instanceof MobileDeviceType && (item = (MobileDeviceType)element).getProperties().containsKey(DefaultDeviceTypeWizardPage.PROPERTY_ICON)) {
                String path = item.getProperties().getProperty(DefaultDeviceTypeWizardPage.PROPERTY_ICON);
                Image image = DevicePlugin.getDefault().getImageFromRegistry(item.getBundleName(), path);
                return image;
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof MobileDeviceType) {
                MobileDeviceType item = (MobileDeviceType)element;
                return item.getLabel();
            }
            return super.getText(element);
        }
    }
}

