/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.status;

import java.util.Collection;
import org.eclipse.tml.common.utilities.BasePlugin;
import org.eclipse.tml.common.utilities.PluginUtils;
import org.eclipse.tml.framework.status.IStatus;
import org.eclipse.tml.framework.status.StatusFactory;
import org.eclipse.tml.framework.status.StatusRegistry;

public class StatusManager {
    private static StatusManager _instance;

    private StatusManager() {
        this.loadStatus();
    }

    public static StatusManager getInstance() {
        if (_instance == null) {
            _instance = new StatusManager();
        }
        return _instance;
    }

    public void loadStatus() {
        Collection statusIds = PluginUtils.getInstalledPlugins((String)"org.eclipse.tml.status");
        StatusRegistry.getInstance().clear();
        for (String statusId : statusIds) {
            IStatus status = StatusFactory.createStatus(statusId);
            StatusRegistry.getInstance().addStatus(status);
        }
    }

    public void listStatus() {
        for (IStatus status : StatusRegistry.getInstance().getStatus()) {
            BasePlugin.logInfo((String)status.toString());
        }
    }
}

