/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.common.utilities;

import java.net.URL;
import java.util.Hashtable;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tml.common.utilities.logger.ILogger;
import org.eclipse.tml.common.utilities.logger.LoggerFactory;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasePlugin
extends AbstractUIPlugin {
    private static BasePlugin baseInst = null;
    protected static ILogger log = null;
    private Hashtable<String, ImageDescriptor> imageDescriptorRegistry = null;
    private boolean headless;
    private boolean headlessSet;

    public static BasePlugin getBaseDefault() {
        return baseInst;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = BasePlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        Display d = Display.getCurrent();
        if (d != null) {
            return d.getActiveShell();
        }
        d = Display.getDefault();
        if (d != null) {
            return d.getActiveShell();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbench wb = null;
        try {
            wb = BasePlugin.getBaseDefault().getWorkbench();
        }
        catch (Exception exception) {
            wb = null;
        }
        if (wb != null) {
            if (Display.getCurrent() != null) {
                return wb.getActiveWorkbenchWindow();
            }
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (windows != null && windows.length > 0) {
                return windows[0];
            }
            return null;
        }
        return null;
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        return BasePlugin.getWorkspace().getRoot();
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getIconPath() {
        return "icons/";
    }

    public static ImageDescriptor getPluginImage(Bundle bundle, String fileName) {
        URL path = bundle.getEntry("/" + fileName);
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)path);
        return descriptor;
    }

    public static void logInfo(String message) {
        BasePlugin.getLogger().info(message);
    }

    public static void logWarning(String message) {
        BasePlugin.getLogger().warn(message);
    }

    public static void logError(String message) {
        BasePlugin.getLogger().error(message);
    }

    public static void logError(String message, Throwable exception) {
        BasePlugin.getLogger().error(message, exception);
    }

    public static void logDebugMessage(String prefix, String message) {
        BasePlugin.getLogger().debug(String.valueOf(prefix) + "-" + message);
    }

    public BasePlugin() {
        if (baseInst == null) {
            baseInst = this;
        }
        this.headless = false;
        this.headlessSet = false;
    }

    public String getSymbolicName() {
        return this.getBundle().getSymbolicName();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void setLogger(ILogger logger) {
        log = logger;
    }

    public static void setDefaultLogger() {
        if (log == null) {
            log = LoggerFactory.getLogger(-1);
        }
    }

    public void stop(BundleContext context) throws Exception {
        BasePlugin.logDebugMessage(((Object)((Object)this)).getClass().getName(), "SHUTDOWN");
        super.stop(context);
    }

    public IWorkbench getWorkbench() {
        IWorkbench wb = null;
        if (this.headlessSet && this.headless) {
            return wb;
        }
        try {
            wb = PlatformUI.getWorkbench();
            this.headless = false;
        }
        catch (Exception exception) {
            this.headless = true;
        }
        this.headlessSet = true;
        return wb;
    }

    protected abstract void initializeImageRegistry();

    protected ImageDescriptor putImageInRegistry(String id, String fileName) {
        ImageDescriptor fid = this.getPluginImage(fileName);
        Hashtable<String, ImageDescriptor> t = this.getImageDescriptorRegistry();
        t.put(id, fid);
        return fid;
    }

    public ImageDescriptor getPluginImage(String imagePath) {
        return BasePlugin.getPluginImage(this.getBundle(), imagePath);
    }

    public Image getImage(String key) {
        ImageRegistry imageRegistry = this.getImageRegistry();
        Image image = imageRegistry.get(key);
        if (image == null) {
            ImageDescriptor descriptor = this.getImageDescriptor(key);
            if (descriptor != null) {
                imageRegistry.put(key, descriptor);
                image = imageRegistry.get(key);
            } else {
                BasePlugin.logError("...error retrieving image for key: " + key);
            }
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String key) {
        Hashtable<String, ImageDescriptor> t = this.getImageDescriptorRegistry();
        ImageDescriptor descriptor = t.get(key);
        return descriptor;
    }

    private Hashtable<String, ImageDescriptor> getImageDescriptorRegistry() {
        if (this.imageDescriptorRegistry == null) {
            this.imageDescriptorRegistry = new Hashtable();
            this.initializeImageRegistry();
        }
        return this.imageDescriptorRegistry;
    }

    public ImageDescriptor getImageDescriptorFromIDE(String relativePath) {
        Hashtable<String, ImageDescriptor> registry = this.getImageDescriptorRegistry();
        ImageDescriptor descriptor = registry.get(relativePath);
        if (descriptor == null) {
            String iconPath = "icons/full/";
            String key = String.valueOf(iconPath) + relativePath;
            String[] bundleNames = new String[]{"org.eclipse.ui", "org.eclipse.ui.ide"};
            int i = 0;
            while (i < bundleNames.length && descriptor == null) {
                String bundleName = bundleNames[i];
                Bundle bundle = Platform.getBundle((String)bundleName);
                URL url = bundle.getResource(key);
                if (url != null) {
                    descriptor = ImageDescriptor.createFromURL((URL)url);
                }
                ++i;
            }
            if (descriptor == null) {
                descriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            registry.put(relativePath, descriptor);
        }
        return descriptor;
    }

    public static ILogger getLogger() {
        if (log == null) {
            BasePlugin.setDefaultLogger();
        }
        return log;
    }

    public boolean isHeadless() {
        if (!this.headlessSet) {
            this.getWorkbench();
        }
        return this.headless;
    }
}

