/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device.ui.view.provider;

import java.util.HashMap;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.tml.framework.device.factory.DeviceTypeRegistry;
import org.eclipse.tml.framework.device.factory.InstanceRegistry;
import org.eclipse.tml.framework.device.model.IDeviceType;
import org.eclipse.tml.framework.device.model.IInstance;
import org.eclipse.tml.framework.device.ui.view.model.ViewerAbstractNode;
import org.eclipse.tml.framework.device.ui.view.model.ViewerDeviceNode;
import org.eclipse.tml.framework.device.ui.view.model.ViewerInstanceNode;
import org.eclipse.ui.IViewSite;

public class InstanceMgtViewContentProvider
implements ITreeContentProvider {
    private static IViewSite treeParent;

    public Object[] getChildren(Object parentElement) {
        Object[] children = null;
        if (parentElement instanceof ViewerAbstractNode) {
            ViewerAbstractNode parentNode = (ViewerAbstractNode)parentElement;
            children = parentNode.getChildren().toArray();
        }
        return children;
    }

    public Object getParent(Object element) {
        ViewerAbstractNode parentElement = null;
        if (element instanceof ViewerAbstractNode) {
            ViewerAbstractNode node = (ViewerAbstractNode)element;
            parentElement = node.getParent();
        }
        return parentElement;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        Object[] elements;
        if (inputElement instanceof IViewSite) {
            if (treeParent == null) {
                treeParent = (IViewSite)inputElement;
            }
            HashMap<String, ViewerDeviceNode> deviceNodeMap = new HashMap<String, ViewerDeviceNode>();
            for (IDeviceType device : DeviceTypeRegistry.getInstance().getDeviceTypes()) {
                if (device.isAbstract()) continue;
                ViewerDeviceNode deviceNode = new ViewerDeviceNode(device);
                deviceNodeMap.put(device.getId(), deviceNode);
            }
            InstanceRegistry instanceRegistry = InstanceRegistry.getInstance();
            for (IInstance instance : instanceRegistry.getInstances()) {
                String deviceId = instance.getDeviceTypeId();
                ViewerDeviceNode deviceNode = (ViewerDeviceNode)deviceNodeMap.get(deviceId);
                if (deviceNode == null) continue;
                deviceNode.addChild(new ViewerInstanceNode(deviceNode, instance));
            }
            for (ViewerDeviceNode deviceNode : deviceNodeMap.values()) {
                if (deviceNode.hasChildren()) continue;
                deviceNode.addChild(new ViewerInstanceNode(deviceNode, null));
            }
            elements = deviceNodeMap.values().toArray();
        } else {
            elements = this.getChildren(inputElement);
        }
        return elements;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

