/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.pulsar.core;

import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.sequoyah.pulsar.internal.core.Messages;
import org.eclipse.sequoyah.pulsar.internal.provisional.core.ISDKRepositoryProvider;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.sequoyah.pulsar.core";
    private static final String SDK_REPOSITORY_PROVIDER_EXTENSION = "org.eclipse.sequoyah.pulsar.core.sdkRepositoryProvider";
    private static final String PULSAR_BROWSER_ID = "pulsar_browser";
    private Collection<ISDKRepositoryProvider> providers;
    private static Activator plugin;

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        plugin = null;
        super.stop(bundleContext);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public Collection<ISDKRepositoryProvider> getSDKRepositoryProviders() {
        if (this.providers == null) {
            this.readSDKRepositoryProviderExtensions();
        }
        return this.providers;
    }

    private void readSDKRepositoryProviderExtensions() {
        IConfigurationElement[] iConfigurationElementArray;
        this.providers = new ArrayList<ISDKRepositoryProvider>();
        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(SDK_REPOSITORY_PROVIDER_EXTENSION);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
            try {
                Object object = iConfigurationElement.createExecutableExtension("class");
                this.providers.add((ISDKRepositoryProvider)object);
            }
            catch (Exception exception) {
                Activator.logError(Messages.Activator_CouldNotCreateExtensionError, exception);
            }
            ++n2;
        }
    }

    public static IStatus makeStatus(int n, String string, Throwable throwable) {
        return new Status(n, PLUGIN_ID, string, throwable);
    }

    public static IStatus makeErrorStatus(String string, Throwable throwable) {
        return new Status(4, PLUGIN_ID, string, throwable);
    }

    public static void logWarning(String string, Throwable throwable) {
        plugin.getLog().log(Activator.makeStatus(2, string, throwable));
    }

    public static void logError(String string, Throwable throwable) {
        plugin.getLog().log(Activator.makeStatus(4, string, throwable));
    }

    public static BundleContext getContext() {
        return plugin.getBundle().getBundleContext();
    }

    public static void openWebBrowser(URL uRL) throws CoreException {
        try {
            IWebBrowser iWebBrowser = PlatformUI.getWorkbench().getBrowserSupport().createBrowser(PULSAR_BROWSER_ID);
            iWebBrowser.openURL(uRL);
        }
        catch (Exception exception) {
            throw new CoreException(Activator.makeErrorStatus(MessageFormat.format(Messages.Activator_ErrorOpeningBrowserError, uRL.toString()), exception));
        }
    }
}

