/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.pulsar.internal.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.core.DefaultAgentProvider;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.sequoyah.pulsar.core.Activator;
import org.eclipse.sequoyah.pulsar.internal.core.SDK;
import org.eclipse.sequoyah.pulsar.internal.provisional.core.ISDK;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2Utils {
    public static final String PROP_PULSAR_PROFILE = "org.eclipse.pulsar.profile";

    public static boolean isInstalled(IInstallableUnit iInstallableUnit) {
        IQuery iQuery = QueryUtil.createIUQuery((String)iInstallableUnit.getId(), (Version)iInstallableUnit.getVersion());
        BundleContext bundleContext = Activator.getContext();
        IProvisioningAgent iProvisioningAgent = P2Utils.getProvisioningAgent(bundleContext);
        IProfileRegistry iProfileRegistry = (IProfileRegistry)iProvisioningAgent.getService(IProfileRegistry.SERVICE_NAME);
        IProfile[] iProfileArray = iProfileRegistry.getProfiles();
        int n = iProfileArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProfile iProfile = iProfileArray[n2];
            IQueryResult iQueryResult = iProfile.query(iQuery, (IProgressMonitor)new NullProgressMonitor());
            if (!iQueryResult.isEmpty()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static ServiceReference getProvisiningAgentReference(BundleContext bundleContext) {
        ServiceReference serviceReference = bundleContext.getServiceReference(IProvisioningAgent.SERVICE_NAME);
        return serviceReference;
    }

    public static IProfile createProfile(String string, IPath iPath) throws ProvisionException {
        BundleContext bundleContext = Activator.getContext();
        IProvisioningAgent iProvisioningAgent = P2Utils.getProvisioningAgent(bundleContext);
        IProfileRegistry iProfileRegistry = (IProfileRegistry)iProvisioningAgent.getService(IProfileRegistry.SERVICE_NAME);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (iPath != null) {
            hashMap.put("org.eclipse.equinox.p2.installFolder", iPath.toOSString());
        }
        hashMap.put(PROP_PULSAR_PROFILE, Boolean.TRUE.toString());
        return iProfileRegistry.addProfile(string, hashMap);
    }

    public static void deleteProfile(String string) {
        BundleContext bundleContext = Activator.getContext();
        IProvisioningAgent iProvisioningAgent = P2Utils.getProvisioningAgent(bundleContext);
        IProfileRegistry iProfileRegistry = (IProfileRegistry)iProvisioningAgent.getService(IProfileRegistry.SERVICE_NAME);
        iProfileRegistry.removeProfile(string);
    }

    public static IProfile createProfileForSDK(ISDK iSDK, IPath iPath) throws ProvisionException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("org.eclipse.pulsar.profile.");
        stringBuilder.append(((SDK)iSDK).getInstallableUnit().getId());
        stringBuilder.append(".");
        stringBuilder.append(System.currentTimeMillis());
        return P2Utils.createProfile(stringBuilder.toString(), iPath);
    }

    public static boolean isSupportedProfile(IProfile iProfile) {
        return iProfile.getProperty(PROP_PULSAR_PROFILE) != null;
    }

    public static Collection<IProfile> getProfiles() {
        BundleContext bundleContext = Activator.getContext();
        IProvisioningAgent iProvisioningAgent = P2Utils.getProvisioningAgent(bundleContext);
        IProfileRegistry iProfileRegistry = (IProfileRegistry)iProvisioningAgent.getService(IProfileRegistry.SERVICE_NAME);
        ArrayList<IProfile> arrayList = new ArrayList<IProfile>();
        IProfile[] iProfileArray = iProfileRegistry.getProfiles();
        int n = iProfileArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProfile iProfile = iProfileArray[n2];
            if (P2Utils.isSupportedProfile(iProfile)) {
                arrayList.add(iProfile);
            }
            ++n2;
        }
        return arrayList;
    }

    public static IProvisioningAgent getProvisioningAgent(BundleContext bundleContext) {
        DefaultAgentProvider defaultAgentProvider = new DefaultAgentProvider();
        defaultAgentProvider.activate(bundleContext);
        IProvisioningAgent iProvisioningAgent = defaultAgentProvider.createAgent(null);
        return iProvisioningAgent;
    }

    public static Set<String> getInstalledFeatureIds(IProgressMonitor iProgressMonitor) {
        HashSet<String> hashSet = new HashSet<String>();
        BundleContext bundleContext = Activator.getContext();
        IProvisioningAgent iProvisioningAgent = P2Utils.getProvisioningAgent(bundleContext);
        IProfileRegistry iProfileRegistry = (IProfileRegistry)iProvisioningAgent.getService(IProfileRegistry.SERVICE_NAME);
        IProfile iProfile = iProfileRegistry.getProfile("_SELF_");
        IQuery iQuery = QueryUtil.createMatchQuery((String)"properties['org.eclipse.pulsar.type'] != null", (Object[])new Object[0]);
        IQueryResult iQueryResult = iProfile.query(iQuery, iProgressMonitor);
        Iterator iterator = iQueryResult.iterator();
        while (iterator.hasNext()) {
            hashSet.add(((IInstallableUnit)iterator.next()).getId());
        }
        return hashSet;
    }
}

