/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.pulsar.internal.provisional.core;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.sequoyah.pulsar.internal.provisional.core.IInstallationEnvironment;

public class IUInstallationEnvironment
implements IInstallationEnvironment {
    private String arch = "all";
    private String os = "all";
    private String ws = "all";

    public IUInstallationEnvironment(String string) {
        if (string != null) {
            Matcher matcher = Pattern.compile("osgi[.]([^=])+[=]([^)])+").matcher(string);
            while (matcher.find()) {
                String[] stringArray = matcher.group().split("=");
                this.processKeyValuePair(stringArray);
            }
        }
    }

    public String getTargetOS() {
        return this.os;
    }

    public String getTargetOSArch() {
        return this.arch;
    }

    public String getTargetWS() {
        return this.ws;
    }

    private void processKeyValuePair(String[] stringArray) {
        String string = stringArray[0];
        if (string.equals("osgi.os")) {
            this.os = stringArray[1].trim();
        } else if (string.equals("osgi.ws")) {
            this.ws = stringArray[1].trim();
        } else if (string.equals("osgi.arch")) {
            this.arch = stringArray[1].trim();
        }
    }
}

