/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.pulsar.internal.ui.view;

import java.net.URI;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.internal.p2.console.ProvisioningHelper;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.internal.p2.operations.PlanAnalyzer;
import org.eclipse.equinox.internal.p2.ui.dialogs.PreselectedIUInstallWizard;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningOperationWizard;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningWizardDialog;
import org.eclipse.equinox.internal.p2.ui.dialogs.UninstallWizard;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKUIActivator;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.UninstallOperation;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.ui.LoadMetadataRepositoryJob;
import org.eclipse.equinox.p2.ui.Policy;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.sequoyah.pulsar.internal.core.SDK;
import org.eclipse.sequoyah.pulsar.internal.provisional.core.IInstallerUI;
import org.eclipse.sequoyah.pulsar.internal.provisional.core.ISDK;
import org.eclipse.sequoyah.pulsar.internal.provisional.core.ISDKRepository;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2InstallerUI
implements IInstallerUI {
    private static P2InstallerUI instance;

    private P2InstallerUI() {
    }

    public static IInstallerUI getInstance() {
        if (instance == null) {
            instance = new P2InstallerUI();
        }
        return instance;
    }

    public void runInstaller(final Shell shell, ISDK iSDK) throws CoreException {
        SDK sDK = (SDK)iSDK.getAdapter(SDK.class);
        final InstallableUnit[] installableUnitArray = this.getInstallableUnits(sDK);
        URI uRI = sDK.getRepository().getArtifactsURI();
        URI uRI2 = sDK.getRepository().getMetadataURI();
        final ProvisioningUI provisioningUI = ProvisioningUI.getDefaultUI();
        ProvisioningSession provisioningSession = provisioningUI.getSession();
        provisioningSession.getArtifactRepositoryManager().addRepository(uRI);
        provisioningSession.getMetadataRepositoryManager().addRepository(uRI2);
        final InstallOperation installOperation = new InstallOperation(provisioningSession, (IInstallableUnit[])installableUnitArray);
        Job job = new Job("Preparing"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                IStatus iStatus = installOperation.resolveModal(iProgressMonitor);
                return iStatus;
            }
        };
        job.schedule();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent iJobChangeEvent) {
                IProvisioningPlan iProvisioningPlan = installOperation.getProvisioningPlan();
                if (iProvisioningPlan != null) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            LoadMetadataRepositoryJob loadMetadataRepositoryJob = new LoadMetadataRepositoryJob(provisioningUI);
                            PreselectedIUInstallWizard preselectedIUInstallWizard = new PreselectedIUInstallWizard(provisioningUI, installOperation, (IInstallableUnit[])installableUnitArray, loadMetadataRepositoryJob);
                            WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)preselectedIUInstallWizard);
                            wizardDialog.create();
                            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)wizardDialog.getShell(), "org.eclipse.equinox.p2.ui.install_wizard_context");
                            wizardDialog.open();
                        }
                    });
                }
            }
        });
    }

    public void runUninstaller(final Shell shell, ISDK iSDK) throws CoreException {
        SDK sDK = (SDK)iSDK.getAdapter(SDK.class);
        final InstallableUnit[] installableUnitArray = this.getInstallableUnits(sDK);
        final ProvisioningUI provisioningUI = ProvisioningUI.getDefaultUI();
        ProvisioningSession provisioningSession = provisioningUI.getSession();
        final UninstallOperation uninstallOperation = new UninstallOperation(provisioningSession, (IInstallableUnit[])installableUnitArray);
        Job job = new Job("Preparing"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                IStatus iStatus = uninstallOperation.resolveModal(iProgressMonitor);
                return iStatus;
            }
        };
        job.schedule();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent iJobChangeEvent) {
                IProvisioningPlan iProvisioningPlan = uninstallOperation.getProvisioningPlan();
                if (iProvisioningPlan != null && PlatformUI.isWorkbenchRunning()) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            LoadMetadataRepositoryJob loadMetadataRepositoryJob = new LoadMetadataRepositoryJob(provisioningUI);
                            UninstallWizard uninstallWizard = new UninstallWizard(provisioningUI, uninstallOperation, (IInstallableUnit[])installableUnitArray, loadMetadataRepositoryJob);
                            ProvisioningWizardDialog provisioningWizardDialog = new ProvisioningWizardDialog(shell, (ProvisioningOperationWizard)uninstallWizard);
                            provisioningWizardDialog.create();
                            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)provisioningWizardDialog.getShell(), "org.eclipse.equinox.p2.ui.uinstall_wizard_context");
                            provisioningWizardDialog.open();
                        }
                    });
                }
            }
        });
    }

    public void refreshSDKRepositories(Collection<ISDKRepository> collection) {
        int n = 0;
        for (ISDKRepository iSDKRepository : collection) {
            ProvisioningHelper.addMetadataRepository((URI)iSDKRepository.getMetadataURI());
            ProvisioningHelper.addArtifactRepository((URI)iSDKRepository.getArtifactsURI());
            ++n;
        }
    }

    private ProfileChangeRequest getProfileChangeRequest(IInstallableUnit[] iInstallableUnitArray, String string, MultiStatus multiStatus, IProgressMonitor iProgressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (String)"", (int)1);
        ProfileChangeRequest profileChangeRequest = null;
        try {
            profileChangeRequest = ProfileChangeRequest.createByProfileId((String)string);
            profileChangeRequest.removeInstallableUnits(iInstallableUnitArray);
            String string2 = this.getPolicy().getVisibleInstalledIUQuery().getId();
            int n = 0;
            while (n < iInstallableUnitArray.length) {
                profileChangeRequest.removeInstallableUnitProfileProperty(iInstallableUnitArray[n], string2);
                ++n;
            }
        }
        finally {
            subMonitor.done();
        }
        return profileChangeRequest;
    }

    private URI getMetadataURI(SDK sDK) {
        return sDK.getRepository().getMetadataURI();
    }

    private InstallableUnit[] getInstallableUnits(SDK sDK) {
        IInstallableUnit iInstallableUnit = sDK.getInstallableUnit();
        InstallableUnitQuery installableUnitQuery = new InstallableUnitQuery(iInstallableUnit.getId(), iInstallableUnit.getVersion());
        IQueryResult iQueryResult = ProvisioningHelper.getInstallableUnits((URI)this.getMetadataURI(sDK), (IQuery)installableUnitQuery, (IProgressMonitor)new NullProgressMonitor());
        return (InstallableUnit[])iQueryResult.toArray(InstallableUnit.class);
    }

    private Policy getPolicy() {
        return null;
    }

    private String getProfileID() throws ProvisionException {
        return ProvSDKUIActivator.getDefault().getProvisioningUI().getProfileId();
    }

    private MultiStatus getStatus() {
        return PlanAnalyzer.getProfileChangeAlteredStatus();
    }
}

