/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.pulsar.internal.ui.view;

import java.net.URI;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.operations.UninstallOperation;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.LoadMetadataRepositoryJob;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.sequoyah.pulsar.internal.core.SDK;
import org.eclipse.sequoyah.pulsar.internal.provisional.core.IInstallerUI;
import org.eclipse.sequoyah.pulsar.internal.provisional.core.ISDK;
import org.eclipse.sequoyah.pulsar.internal.provisional.core.ISDKRepository;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2InstallerUI
implements IInstallerUI {
    private static P2InstallerUI instance;

    private P2InstallerUI() {
    }

    public static IInstallerUI getInstance() {
        if (instance == null) {
            instance = new P2InstallerUI();
        }
        return instance;
    }

    public void runInstaller(Shell shell, ISDK iSDK) throws CoreException {
        SDK sDK = (SDK)iSDK.getAdapter(SDK.class);
        Collection<IInstallableUnit> collection = this.getInstallableUnits(sDK);
        URI uRI = sDK.getRepository().getArtifactsURI();
        URI uRI2 = sDK.getRepository().getMetadataURI();
        ProvisioningUI provisioningUI = ProvisioningUI.getDefaultUI();
        ProvisioningSession provisioningSession = provisioningUI.getSession();
        IProvisioningAgent iProvisioningAgent = provisioningSession.getProvisioningAgent();
        IMetadataRepositoryManager iMetadataRepositoryManager = (IMetadataRepositoryManager)iProvisioningAgent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        iMetadataRepositoryManager.addRepository(uRI2);
        IArtifactRepositoryManager iArtifactRepositoryManager = (IArtifactRepositoryManager)iProvisioningAgent.getService(IArtifactRepositoryManager.SERVICE_NAME);
        iArtifactRepositoryManager.addRepository(uRI);
        LoadMetadataRepositoryJob loadMetadataRepositoryJob = new LoadMetadataRepositoryJob(provisioningUI);
        InstallOperation installOperation = new InstallOperation(provisioningSession, collection);
        provisioningUI.openInstallWizard(collection, installOperation, loadMetadataRepositoryJob);
    }

    public void runUninstaller(Shell shell, ISDK iSDK) throws CoreException {
        SDK sDK = (SDK)iSDK.getAdapter(SDK.class);
        Collection<IInstallableUnit> collection = this.getInstallableUnits(sDK);
        URI uRI = sDK.getRepository().getArtifactsURI();
        URI uRI2 = sDK.getRepository().getMetadataURI();
        ProvisioningUI provisioningUI = ProvisioningUI.getDefaultUI();
        ProvisioningSession provisioningSession = provisioningUI.getSession();
        IProvisioningAgent iProvisioningAgent = provisioningSession.getProvisioningAgent();
        UninstallOperation uninstallOperation = new UninstallOperation(provisioningSession, collection);
        LoadMetadataRepositoryJob loadMetadataRepositoryJob = new LoadMetadataRepositoryJob(provisioningUI);
        IMetadataRepositoryManager iMetadataRepositoryManager = (IMetadataRepositoryManager)iProvisioningAgent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        iMetadataRepositoryManager.addRepository(uRI2);
        IArtifactRepositoryManager iArtifactRepositoryManager = (IArtifactRepositoryManager)iProvisioningAgent.getService(IArtifactRepositoryManager.SERVICE_NAME);
        iArtifactRepositoryManager.addRepository(uRI);
        provisioningUI.openUninstallWizard(collection, uninstallOperation, loadMetadataRepositoryJob);
    }

    public void refreshSDKRepositories(Collection<ISDKRepository> collection) {
        int n = 0;
        ProvisioningUI provisioningUI = ProvisioningUI.getDefaultUI();
        RepositoryTracker repositoryTracker = provisioningUI.getRepositoryTracker();
        for (ISDKRepository iSDKRepository : collection) {
            URI[] uRIArray = new URI[]{iSDKRepository.getMetadataURI(), iSDKRepository.getArtifactsURI()};
            repositoryTracker.refreshRepositories(uRIArray, provisioningUI.getSession(), (IProgressMonitor)new NullProgressMonitor());
            ++n;
        }
    }

    private URI getMetadataURI(SDK sDK) {
        return sDK.getRepository().getMetadataURI();
    }

    private Collection<IInstallableUnit> getInstallableUnits(SDK sDK) {
        IInstallableUnit iInstallableUnit = sDK.getInstallableUnit();
        ProvisioningUI provisioningUI = ProvisioningUI.getDefaultUI();
        ProvisioningSession provisioningSession = provisioningUI.getSession();
        IProvisioningAgent iProvisioningAgent = provisioningSession.getProvisioningAgent();
        IMetadataRepositoryManager iMetadataRepositoryManager = (IMetadataRepositoryManager)iProvisioningAgent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        IMetadataRepository iMetadataRepository = null;
        IQueryResult iQueryResult = null;
        try {
            iMetadataRepository = iMetadataRepositoryManager.loadRepository(this.getMetadataURI(sDK), (IProgressMonitor)new NullProgressMonitor());
            IQuery iQuery = QueryUtil.createIUQuery((String)iInstallableUnit.getId(), (Version)iInstallableUnit.getVersion());
            iQueryResult = iMetadataRepository.query(iQuery, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ProvisionException provisionException) {
        }
        catch (OperationCanceledException operationCanceledException) {}
        return iQueryResult.toSet();
    }
}

