/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.visibility;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.Disposable;
import org.eclipse.gef.RootEditPart;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactory;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactoryProvider;
import org.eclipse.sirius.diagram.ui.business.api.provider.AbstractDDiagramElementLabelItemProvider;
import org.eclipse.sirius.diagram.ui.business.api.provider.DEdgeBeginLabelItemProvider;
import org.eclipse.sirius.diagram.ui.business.api.provider.DEdgeEndLabelItemProvider;
import org.eclipse.sirius.diagram.ui.business.api.provider.DEdgeLabelItemProvider;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.visibility.AbstractRevealElementsAction;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.DiagramOutlinePage;

public class RevealOutlineLabelsAction
extends AbstractRevealElementsAction<Object>
implements Disposable {
    private Map<EObject, List<Integer>> semanticToLabelsVisualIDToHideMap = new HashMap<EObject, List<Integer>>();

    public RevealOutlineLabelsAction() {
        this(Messages.RevealOutlineLabelsAction_label);
    }

    public RevealOutlineLabelsAction(String text) {
        this(text, DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/categoryLabelVisible.gif"));
    }

    public RevealOutlineLabelsAction(String text, ImageDescriptor image) {
        super(text, image);
        this.setId(text);
    }

    public void dispose() {
        this.semanticToLabelsVisualIDToHideMap = null;
    }

    @Override
    protected boolean doRun(Object element) {
        if (element instanceof DDiagramElement) {
            this.run((DDiagramElement)element);
        } else if (element instanceof AbstractDDiagramElementLabelItemProvider && ((AbstractDDiagramElementLabelItemProvider)((Object)element)).getDiagramElementTarget().some()) {
            this.semanticToLabelsVisualIDToHideMap.clear();
            DDiagramElement dDiagramElement = (DDiagramElement)((AbstractDDiagramElementLabelItemProvider)((Object)element)).getDiagramElementTarget().get();
            if (!this.semanticToLabelsVisualIDToHideMap.keySet().contains(dDiagramElement)) {
                this.semanticToLabelsVisualIDToHideMap.put((EObject)dDiagramElement, new LinkedList());
            }
            List<Integer> visualIDToHideList = this.semanticToLabelsVisualIDToHideMap.get(dDiagramElement);
            if (element instanceof DEdgeBeginLabelItemProvider) {
                visualIDToHideList.add(6002);
            } else if (element instanceof DEdgeLabelItemProvider) {
                visualIDToHideList.add(6001);
            } else if (element instanceof DEdgeEndLabelItemProvider) {
                visualIDToHideList.add(6003);
            }
            this.run(dDiagramElement);
        } else if (element instanceof IDiagramElementEditPart) {
            IDiagramElementEditPart diagramElementEditPart = (IDiagramElementEditPart)element;
            RootEditPart root = diagramElementEditPart.getRoot();
            DDiagramEditor diagramEditor = (DDiagramEditor)root.getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
            this.runRevealCommand(root, diagramEditor, diagramElementEditPart.resolveDiagramElement());
        }
        return true;
    }

    @Override
    protected Class<Object> getElementType() {
        return Object.class;
    }

    private void run(DDiagramElement diagramElement) {
        if (this.selection instanceof DiagramOutlinePage.TreeSelectionWrapper) {
            DiagramOutlinePage.TreeSelectionWrapper wrapper = (DiagramOutlinePage.TreeSelectionWrapper)this.selection;
            RootEditPart root = wrapper.getRoot();
            DDiagramEditor diagramEditor = (DDiagramEditor)wrapper.getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
            this.runRevealCommand(root, diagramEditor, diagramElement);
        }
    }

    private void runRevealCommand(RootEditPart root, DDiagramEditor editor, DDiagramElement vpe) {
        if (vpe != null && new DDiagramElementQuery(vpe).hasAnyHiddenLabel()) {
            Object adapter = editor.getAdapter(IDiagramCommandFactoryProvider.class);
            IDiagramCommandFactoryProvider cmdFactoryProvider = (IDiagramCommandFactoryProvider)adapter;
            TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((ResourceSet)editor.getEditingDomain().getResourceSet());
            IDiagramCommandFactory emfCommandFactory = cmdFactoryProvider.getCommandFactory(transactionalEditingDomain);
            Command cmd = this.semanticToLabelsVisualIDToHideMap.isEmpty() ? emfCommandFactory.buildRevealLabelCommand(vpe) : emfCommandFactory.buildRevealLabelSelectionCommand(vpe, this.semanticToLabelsVisualIDToHideMap);
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)vpe);
            CompoundCommand allInOne = new CompoundCommand(cmd.getLabel());
            allInOne.append(cmd);
            domain.getCommandStack().execute((Command)allInOne);
        }
    }
}

