/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.business.internal.refresh;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.logger.InterpretationContext;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerInterpreter;
import org.eclipse.sirius.common.tools.api.util.CartesianProduct;
import org.eclipse.sirius.common.tools.api.util.EObjectCouple;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ext.base.collect.GSetIntersection;
import org.eclipse.sirius.ext.base.collect.MultipleCollection;
import org.eclipse.sirius.ext.base.collect.SetIntersection;
import org.eclipse.sirius.table.business.api.helper.TableHelper;
import org.eclipse.sirius.table.business.api.query.DTableQuery;
import org.eclipse.sirius.table.business.internal.refresh.AbstractTableSynchronizer;
import org.eclipse.sirius.table.business.internal.refresh.DCellCandidate;
import org.eclipse.sirius.table.business.internal.refresh.DTableElementSynchronizer;
import org.eclipse.sirius.table.business.internal.refresh.DTargetColumnCandidate;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DFeatureColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.DTableElement;
import org.eclipse.sirius.table.metamodel.table.DTargetColumn;
import org.eclipse.sirius.table.metamodel.table.LineContainer;
import org.eclipse.sirius.table.metamodel.table.TableFactory;
import org.eclipse.sirius.table.metamodel.table.description.ColumnMapping;
import org.eclipse.sirius.table.metamodel.table.description.CrossTableDescription;
import org.eclipse.sirius.table.metamodel.table.description.DescriptionPackage;
import org.eclipse.sirius.table.metamodel.table.description.ElementColumnMapping;
import org.eclipse.sirius.table.metamodel.table.description.IntersectionMapping;
import org.eclipse.sirius.table.metamodel.table.description.LineMapping;
import org.eclipse.sirius.table.metamodel.table.description.TableMapping;
import org.eclipse.sirius.table.tools.internal.Messages;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class CrossTableSynchronizer
extends AbstractTableSynchronizer<CrossTableDescription, ElementColumnMapping> {
    public CrossTableSynchronizer(CrossTableDescription description, DTableElementSynchronizer sync) {
        super(description, sync);
    }

    @Override
    protected void initRefreshMonitor(IProgressMonitor monitor) {
        monitor.beginTask(Messages.DTableSynchronizerImpl_refreshCrossTabel, 3);
    }

    @Override
    protected List<ElementColumnMapping> getColumnMappings() {
        return ((CrossTableDescription)this.description).getOwnedColumnMappings();
    }

    @Override
    protected void refreshCells(IProgressMonitor monitor, Map<TableMapping, Collection<DTableElement>> mappingToElements) {
        try {
            monitor.beginTask(Messages.DTableSynchronizerImpl_refreshIntersectionMapping, ((CrossTableDescription)this.description).getIntersection().size());
            if (((CrossTableDescription)this.description).getIntersection().isEmpty()) {
                for (DCell cell : new DTableQuery(this.table).getCells()) {
                    this.sync.removeUneededCell(cell);
                }
            } else {
                for (IntersectionMapping iMapping : ((CrossTableDescription)this.description).getIntersection()) {
                    this.refreshIntersectionMapping(iMapping, mappingToElements);
                    monitor.worked(1);
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    protected int refreshColumnMapping(ElementColumnMapping mapping, Map<TableMapping, Collection<DTableElement>> mappingToElements, int previousCurrentIndex) {
        int currentIndex = previousCurrentIndex;
        if (this.accessor.getPermissionAuthority().canEditInstance((EObject)this.table)) {
            SetIntersection<DTargetColumnCandidate> status = this.computeCurrentStatus(mapping);
            ArrayList<DTableElement> elementsToKeep = new ArrayList<DTableElement>();
            for (DTargetColumnCandidate toDelete : status.getRemovedElements()) {
                if (toDelete.getOriginalElement() == null) continue;
                this.doDeleteColumn((DColumn)toDelete.getOriginalElement());
            }
            for (DTargetColumnCandidate targetColumnCandidate : status.getAllElements()) {
                this.refreshColumnCandidate(targetColumnCandidate, currentIndex, elementsToKeep);
                ++currentIndex;
            }
            this.putOrAdd(mappingToElements, (TableMapping)mapping, elementsToKeep);
        }
        return currentIndex;
    }

    private void refreshColumnCandidate(DTargetColumnCandidate candidate, int currentIndex, Collection<DTableElement> elementsToKeep) {
        if (candidate.getOriginalElement() == null) {
            DTargetColumn newC = this.createNewColumn(candidate.getMapping(), candidate.getSemantic());
            this.sync.refresh((DColumn)newC);
            this.sync.refreshSemanticElements((DTableElement)newC, (TableMapping)candidate.getMapping());
            if (this.accessor.getPermissionAuthority().canCreateIn((EObject)this.table)) {
                this.table.getColumns().add(currentIndex, (Object)newC);
            }
            elementsToKeep.add((DTableElement)newC);
        } else {
            this.sync.refresh((DColumn)candidate.getOriginalElement());
            this.sync.refreshSemanticElements((DTableElement)candidate.getOriginalElement(), (TableMapping)candidate.getMapping());
            DTable parentTable = candidate.getOriginalElement().getTable();
            if (parentTable.getColumns().size() >= currentIndex) {
                if (this.accessor.getPermissionAuthority().canEditInstance((EObject)parentTable) && !candidate.getOriginalElement().equals(parentTable.getColumns().get(currentIndex))) {
                    parentTable.getColumns().move(currentIndex, (Object)candidate.getOriginalElement());
                }
            } else if (this.accessor.getPermissionAuthority().canEditInstance((EObject)parentTable)) {
                parentTable.getColumns().move(parentTable.getColumns().size() - 1, (Object)candidate.getOriginalElement());
            }
            elementsToKeep.add((DTableElement)candidate.getOriginalElement());
        }
    }

    private SetIntersection<DTargetColumnCandidate> computeCurrentStatus(ElementColumnMapping mapping) {
        this.removeTargetLessColumns(mapping);
        GSetIntersection status = new GSetIntersection();
        for (DColumn column : this.table.getColumns()) {
            if (column.getOriginMapping() != mapping || !(column instanceof DTargetColumn)) continue;
            status.addInOld((Object)new DTargetColumnCandidate((DTargetColumn)column, this.ids));
        }
        MultipleCollection semantics = new MultipleCollection();
        if (TableHelper.hasSemanticCandidatesExpression(mapping)) {
            Collection candidates = (Collection)InterpretationContext.with((RuntimeLoggerInterpreter)this.interpreter, ctx -> {
                ctx.setVariable("containerView", (Object)this.table);
                ctx.setVariable("container", (Object)this.table.getTarget());
                ctx.setVariable("viewpoint", (Object)this.table);
                ctx.setVariable("table", (Object)this.table);
                return this.interpreter.evaluateCollection(this.table.getTarget(), (EObject)mapping, (EStructuralFeature)DescriptionPackage.eINSTANCE.getElementColumnMapping_SemanticCandidatesExpression());
            });
            if (!candidates.isEmpty()) {
                semantics.addAll(candidates);
            }
        } else {
            semantics.addAll(this.accessor.eAllContents(this.table.getTarget(), mapping.getDomainClass()));
        }
        for (EObject semantic : semantics) {
            if (!this.accessor.eInstanceOf(semantic, mapping.getDomainClass())) continue;
            status.addInNew((Object)new DTargetColumnCandidate((ColumnMapping)mapping, semantic, this.ids));
        }
        return status;
    }

    private void removeTargetLessColumns(ElementColumnMapping mapping) {
        if (this.accessor.getPermissionAuthority().canEditInstance((EObject)this.table)) {
            ArrayList<DColumn> columnsWithoutTarget = new ArrayList<DColumn>();
            for (DColumn column : this.table.getColumns()) {
                boolean mappingIsObsolete;
                boolean bl = mappingIsObsolete = column.getOriginMapping().eResource() == null || column.getOriginMapping().eIsProxy();
                if (!mappingIsObsolete && (column.getOriginMapping() != mapping || !(column instanceof DFeatureColumn))) continue;
                columnsWithoutTarget.add(column);
            }
            for (DColumn column : this.table.getColumns()) {
                if (column.getTarget() != null) continue;
                columnsWithoutTarget.add(column);
            }
            for (DColumn columnWithoutTarget : columnsWithoutTarget) {
                this.doDeleteColumn(columnWithoutTarget);
            }
        }
    }

    private void refreshIntersectionMapping(IntersectionMapping iMapping, Map<TableMapping, Collection<DTableElement>> mappingToElements) {
        SetIntersection<DCellCandidate> status = null;
        status = iMapping.isUseDomainClass() ? this.refreshIntersectionMappingWithDomain(iMapping, mappingToElements) : this.refreshIntersectionMappingWithoutDomain(iMapping, mappingToElements);
        this.updateCells(iMapping, status);
    }

    private SetIntersection<DCellCandidate> refreshIntersectionMappingWithDomain(IntersectionMapping iMapping, Map<TableMapping, Collection<DTableElement>> mappingToElements) {
        GSetIntersection status = new GSetIntersection();
        this.setOldCellCandidatesWithDomain(iMapping, (SetIntersection<DCellCandidate>)status);
        Collection<EObject> targetCandidates = this.getTargetCanditatesWithDomain(iMapping);
        if (!targetCandidates.isEmpty()) {
            Map<EObject, Collection<DLine>> linesSemantics = this.groupLinesByTarget(mappingToElements, (List<LineMapping>)iMapping.getLineMapping());
            Map<EObject, Collection<DTargetColumn>> columnSemantics = this.groupDecorators(mappingToElements.getOrDefault(iMapping.getColumnMapping(), Collections.emptyList()), DTargetColumn.class);
            if (!linesSemantics.isEmpty() && !columnSemantics.isEmpty()) {
                this.refreshIntersectionWithDomain(iMapping, (SetIntersection<DCellCandidate>)status, targetCandidates, linesSemantics, columnSemantics);
            }
        }
        return status;
    }

    private void refreshIntersectionWithDomain(IntersectionMapping iMapping, SetIntersection<DCellCandidate> status, Collection<EObject> targetCandidates, Map<EObject, Collection<DLine>> linesSemantics, Map<EObject, Collection<DTargetColumn>> columnSemantics) {
        for (EObject target : targetCandidates) {
            Collection<EObject> columnSemanticCandidates;
            Collection<EObject> lineSemanticCandidates = this.sync.evaluateLineFinderExpression(target, this.table, iMapping);
            if (lineSemanticCandidates.isEmpty() || (columnSemanticCandidates = this.sync.evaluateColumnFinderExpression(target, (LineContainer)this.table, iMapping, true)).isEmpty()) continue;
            for (EObject lineSemantic : lineSemanticCandidates) {
                Collection<DLine> sourceViews = linesSemantics.get(lineSemantic);
                if (sourceViews == null) continue;
                for (EObject columnSemantic : columnSemanticCandidates) {
                    Collection<DTargetColumn> targetViews = columnSemantics.get(columnSemantic);
                    if (targetViews == null) continue;
                    this.setNewCellCandidatesWithDomain(iMapping, status, target, sourceViews, targetViews);
                }
            }
        }
    }

    private void setOldCellCandidatesWithDomain(IntersectionMapping iMapping, SetIntersection<DCellCandidate> status) {
        for (DCell cell : new DTableQuery(this.table).getCells()) {
            boolean mappingIsObsolete;
            IntersectionMapping intersectionMapping = cell.getIntersectionMapping();
            boolean bl = mappingIsObsolete = intersectionMapping == null || intersectionMapping.eResource() == null;
            if (!iMapping.equals(intersectionMapping) && !mappingIsObsolete) continue;
            status.addInOld((Object)new DCellCandidate(cell, this.ids));
        }
    }

    private Collection<EObject> getTargetCanditatesWithDomain(IntersectionMapping iMapping) {
        EObject rootContent = this.table.getTarget();
        Collection result = StringUtil.isEmpty((String)iMapping.getSemanticCandidatesExpression()) ? this.accessor.eAllContents(rootContent, iMapping.getDomainClass()) : (Collection)InterpretationContext.with((RuntimeLoggerInterpreter)this.interpreter, ctx -> {
            ctx.setVariable("root", (Object)rootContent);
            ctx.setVariable("table", (Object)this.table);
            return this.interpreter.evaluateCollection(rootContent, (EObject)iMapping, (EStructuralFeature)DescriptionPackage.eINSTANCE.getIntersectionMapping_SemanticCandidatesExpression());
        });
        return result;
    }

    private void setNewCellCandidatesWithDomain(IntersectionMapping iMapping, SetIntersection<DCellCandidate> status, EObject target, Collection<DLine> sourceViews, Collection<DTargetColumn> targetViews) {
        for (EObjectCouple viewsCouple : new CartesianProduct(sourceViews, targetViews, this.ids)) {
            DLine line = (DLine)viewsCouple.getObj1();
            DColumn column = (DColumn)viewsCouple.getObj2();
            if (!this.sync.evaluateIntersectionPrecondition(column.getTarget(), line, column, iMapping)) continue;
            status.addInNew((Object)new DCellCandidate(iMapping.getColumnMapping(), target, line, column, this.ids));
        }
    }

    private Map<EObject, Collection<DLine>> groupLinesByTarget(Map<TableMapping, Collection<DTableElement>> mappingToElements, List<LineMapping> mappings) {
        MultipleCollection lineViews = new MultipleCollection();
        for (LineMapping lMapping : mappings) {
            Collection<DTableElement> lines = mappingToElements.get(lMapping);
            if (lines == null) continue;
            lineViews.addAll(lines);
        }
        return this.groupDecorators((Collection<?>)lineViews, (Class)DLine.class);
    }

    private <D extends DSemanticDecorator> Map<EObject, Collection<D>> groupDecorators(Collection<?> source, Class<D> expectedType) {
        HashMap<EObject, Collection<D>> result = new HashMap<EObject, Collection<D>>(source.size());
        Function<EObject, Collection> groupProvider = key -> new ArrayList(1);
        for (Object element : source) {
            if (!expectedType.isInstance(element)) continue;
            DSemanticDecorator decorator = (DSemanticDecorator)expectedType.cast(element);
            result.computeIfAbsent(decorator.getTarget(), groupProvider).add(decorator);
        }
        return result;
    }

    private void updateCells(IntersectionMapping iMapping, SetIntersection<DCellCandidate> cellsToUpdate) {
        DCell cell;
        for (DCellCandidate toCreate : cellsToUpdate.getNewElements()) {
            DCell newCell = this.createCell(toCreate.getLine(), toCreate.getColumn(), toCreate.getSemantic(), (ElementColumnMapping)toCreate.getMapping());
            newCell.setIntersectionMapping(iMapping);
            this.sync.refresh(newCell);
        }
        for (DCellCandidate toUpdate : cellsToUpdate.getKeptElements()) {
            cell = toUpdate.getOriginalElement();
            if (cell == null || !this.accessor.getPermissionAuthority().canEditInstance((EObject)cell)) continue;
            if (cell.getTarget() != toUpdate.getSemantic()) {
                cell.setTarget(toUpdate.getSemantic());
            }
            cell.getSemanticElements().add((Object)toUpdate.getSemantic());
            if (cell.getIntersectionMapping() != iMapping) {
                cell.setIntersectionMapping(iMapping);
            }
            this.sync.refresh(cell);
        }
        for (DCellCandidate toRemove : cellsToUpdate.getRemovedElements()) {
            cell = toRemove.getOriginalElement();
            this.sync.removeUneededCell(cell);
        }
    }

    private SetIntersection<DCellCandidate> refreshIntersectionMappingWithoutDomain(IntersectionMapping iMapping, Map<TableMapping, Collection<DTableElement>> mappingToElements) {
        SetIntersection status = new SetIntersection();
        this.setOldCellCandidatesWithDomain(iMapping, (SetIntersection<DCellCandidate>)status);
        Collection targetColumns = mappingToElements.getOrDefault(iMapping.getColumnMapping(), Collections.emptyList());
        if (targetColumns.isEmpty()) {
            return status;
        }
        for (LineMapping curLineMapping : iMapping.getLineMapping()) {
            Collection sourceLines = mappingToElements.getOrDefault(curLineMapping, Collections.emptyList());
            HashMap<DLine, Collection> linesToColumnSemantics = new HashMap<DLine, Collection>();
            for (DTableElement lineElem : sourceLines) {
                for (DTableElement columnElem : targetColumns) {
                    if (!(lineElem instanceof DLine) || !(columnElem instanceof DTargetColumn)) continue;
                    DLine line = (DLine)lineElem;
                    DTargetColumn column = (DTargetColumn)columnElem;
                    Collection columnSemantics = linesToColumnSemantics.computeIfAbsent(line, it -> this.sync.evaluateColumnFinderExpression(line.getTarget(), (LineContainer)line, iMapping, true));
                    if (!columnSemantics.contains(column.getTarget()) || !this.sync.evaluateIntersectionPrecondition(column.getTarget(), line, (DColumn)column, iMapping)) continue;
                    status.addInNew((Object)new DCellCandidate(iMapping.getColumnMapping(), line.getTarget(), line, (DColumn)column, this.ids));
                }
            }
        }
        return status;
    }

    protected DTargetColumn createNewColumn(ColumnMapping mapping, EObject semantic) {
        DTargetColumn column = TableFactory.eINSTANCE.createDTargetColumn();
        column.setOriginMapping(mapping);
        column.setTarget(semantic);
        return column;
    }
}

