/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation;

import org.eclipse.smarthome.automation.RuleStatus;
import org.eclipse.smarthome.automation.RuleStatusDetail;

public class RuleStatusInfo {
    private RuleStatus status;
    private RuleStatusDetail statusDetail;
    private String description;

    protected RuleStatusInfo() {
    }

    public RuleStatusInfo(RuleStatus status) throws IllegalArgumentException {
        this(status, RuleStatusDetail.NONE);
    }

    public RuleStatusInfo(RuleStatus status, RuleStatusDetail statusDetail) throws IllegalArgumentException {
        this(status, statusDetail, null);
    }

    public RuleStatusInfo(RuleStatus status, RuleStatusDetail statusDetail, String description) throws IllegalArgumentException {
        if (status == null) {
            throw new IllegalArgumentException("Thing status must not be null");
        }
        if (statusDetail == null) {
            throw new IllegalArgumentException("Thing status detail must not be null");
        }
        this.status = status;
        this.statusDetail = statusDetail;
        this.description = description;
    }

    public RuleStatus getStatus() {
        return this.status;
    }

    public RuleStatusDetail getStatusDetail() {
        return this.statusDetail;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        boolean hasDescription = this.getDescription() != null && !this.getDescription().isEmpty();
        return (Object)((Object)this.getStatus()) + (this.getStatusDetail() == RuleStatusDetail.NONE ? "" : " (" + (Object)((Object)this.getStatusDetail()) + ")") + (hasDescription ? ": " + this.getDescription() : "");
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.statusDetail == null ? 0 : this.statusDetail.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RuleStatusInfo other = (RuleStatusInfo)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.status != other.status) {
            return false;
        }
        return this.statusDetail == other.statusDetail;
    }
}

