/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.handler;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.handler.ModuleHandler;
import org.eclipse.smarthome.automation.handler.ModuleHandlerFactory;

@NonNullByDefault
public abstract class BaseModuleHandlerFactory
implements ModuleHandlerFactory {
    private final Map<@NonNull String, @NonNull ModuleHandler> handlers = new HashMap<String, ModuleHandler>();

    protected void deactivate() {
        for (ModuleHandler handler : this.handlers.values()) {
            handler.dispose();
        }
        this.handlers.clear();
    }

    protected Map<String, ModuleHandler> getHandlers() {
        return Collections.unmodifiableMap(this.handlers);
    }

    @Override
    public @Nullable ModuleHandler getHandler(Module module, String ruleUID) {
        String id = String.valueOf(ruleUID) + module.getId();
        ModuleHandler handler = this.handlers.get(id);
        ModuleHandler moduleHandler = handler = handler == null ? this.internalCreate(module, ruleUID) : handler;
        if (handler != null) {
            this.handlers.put(id, handler);
        }
        return handler;
    }

    protected abstract @Nullable ModuleHandler internalCreate(Module var1, String var2);

    @Override
    public void ungetHandler(Module module, String ruleUID, ModuleHandler handler) {
        if (this.handlers.remove(String.valueOf(ruleUID) + module.getId(), handler)) {
            handler.dispose();
        }
    }
}

