/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.internal.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.eclipse.smarthome.automation.Rule;
import org.eclipse.smarthome.automation.RuleStatus;
import org.eclipse.smarthome.automation.internal.commands.AutomationCommand;
import org.eclipse.smarthome.automation.internal.commands.AutomationCommandsPluggable;
import org.eclipse.smarthome.automation.internal.commands.Printer;
import org.eclipse.smarthome.automation.internal.commands.Utils;
import org.eclipse.smarthome.automation.template.RuleTemplate;
import org.eclipse.smarthome.automation.template.Template;
import org.eclipse.smarthome.automation.type.ModuleType;
import org.eclipse.smarthome.automation.type.TriggerType;

public class AutomationCommandList
extends AutomationCommand {
    private String id;
    private Locale locale;

    public AutomationCommandList(String command, String[] params, int adminType, AutomationCommandsPluggable autoCommands) {
        super(command, params, adminType, autoCommands);
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
    }

    @Override
    public String execute() {
        if (this.parsingResult != "SUCCESS") {
            return this.parsingResult;
        }
        if (this.providerType == 3) {
            return this.listModuleTypes();
        }
        if (this.providerType == 2) {
            return this.listTemplates();
        }
        if (this.providerType == 1) {
            return this.listRules();
        }
        return "FAIL";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String parseOptionsAndParameters(String[] parameterValues) {
        boolean getId = true;
        boolean getLocale = true;
        int i = 0;
        while (i < parameterValues.length) {
            if (parameterValues[i] != null) {
                if (parameterValues[i].charAt(0) == '-') {
                    if (!parameterValues[i].equals("-st")) return String.format("Unsupported option: %s", parameterValues[i]);
                    this.st = true;
                } else if (getId) {
                    this.id = parameterValues[i];
                    getId = false;
                } else {
                    if (getLocale) {
                        String l = parameterValues[i];
                        this.locale = new Locale(l);
                        getLocale = false;
                    }
                    if (getId && getLocale) {
                        return String.format("Unsupported parameter: %s", parameterValues[i]);
                    }
                }
            }
            ++i;
        }
        return "SUCCESS";
    }

    private String listRules() {
        Collection<Rule> collection = this.autoCommands.getRules();
        Hashtable rules = new Hashtable();
        Map<String, String> listRules = null;
        if (collection != null && !collection.isEmpty()) {
            this.addCollection(collection, rules);
            String[] uids = new String[rules.size()];
            Utils.quickSort(rules.keySet().toArray(uids), 0, rules.size());
            listRules = Utils.putInHastable(uids);
        }
        if (listRules != null && !listRules.isEmpty()) {
            if (this.id != null) {
                collection = this.getRuleByFilter(listRules);
                if (collection.size() == 1) {
                    Rule r = (Rule)collection.toArray()[0];
                    if (r != null) {
                        RuleStatus status = this.autoCommands.getRuleStatus(r.getUID());
                        return Printer.printRule(r, status);
                    }
                    return String.format("Nonexistent ID: %s", this.id);
                }
                if (collection.isEmpty()) {
                    return String.format("Nonexistent ID: %s", this.id);
                }
                if (!rules.isEmpty()) {
                    rules.clear();
                }
                this.addCollection(collection, rules);
                listRules = Utils.filterList(rules, listRules);
            }
            return Printer.printRules(this.autoCommands, listRules);
        }
        return "There are no Rules available!";
    }

    private String listTemplates() {
        Collection<RuleTemplate> collection = this.autoCommands.getTemplates(this.locale);
        Hashtable templates = new Hashtable();
        Map<String, String> listTemplates = null;
        if (collection != null && !collection.isEmpty()) {
            this.addCollection(collection, templates);
            String[] uids = new String[templates.size()];
            Utils.quickSort(templates.keySet().toArray(uids), 0, templates.size());
            listTemplates = Utils.putInHastable(uids);
        }
        if (listTemplates != null && !listTemplates.isEmpty()) {
            if (this.id != null) {
                collection = this.getTemplateByFilter(listTemplates);
                if (collection.size() == 1) {
                    Template t = (Template)collection.toArray()[0];
                    if (t != null) {
                        return Printer.printTemplate(t);
                    }
                    return String.format("Nonexistent ID: %s", this.id);
                }
                if (collection.isEmpty()) {
                    return String.format("Nonexistent ID: %s", this.id);
                }
                if (!templates.isEmpty()) {
                    templates.clear();
                }
                this.addCollection(collection, templates);
                listTemplates = Utils.filterList(templates, listTemplates);
            }
            if (listTemplates != null && !listTemplates.isEmpty()) {
                return Printer.printTemplates(listTemplates);
            }
        }
        return "There are no Templates available!";
    }

    private String listModuleTypes() {
        Hashtable moduleTypes = new Hashtable();
        Collection<TriggerType> collection = this.autoCommands.getTriggers(this.locale);
        this.addCollection(collection, moduleTypes);
        collection = this.autoCommands.getConditions(this.locale);
        this.addCollection(collection, moduleTypes);
        collection = this.autoCommands.getActions(this.locale);
        this.addCollection(collection, moduleTypes);
        Map<String, String> listModuleTypes = null;
        if (!moduleTypes.isEmpty()) {
            String[] uids = new String[moduleTypes.size()];
            Utils.quickSort(moduleTypes.keySet().toArray(uids), 0, moduleTypes.size());
            listModuleTypes = Utils.putInHastable(uids);
        }
        if (listModuleTypes != null && !listModuleTypes.isEmpty()) {
            if (this.id != null) {
                collection = this.getModuleTypeByFilter(listModuleTypes);
                if (collection.size() == 1) {
                    ModuleType mt = (ModuleType)collection.toArray()[0];
                    if (mt != null) {
                        return Printer.printModuleType(mt);
                    }
                    return String.format("Nonexistent ID: %s", this.id);
                }
                if (collection.isEmpty()) {
                    return String.format("Nonexistent ID: %s", this.id);
                }
                if (!moduleTypes.isEmpty()) {
                    moduleTypes.clear();
                }
                this.addCollection(collection, moduleTypes);
                listModuleTypes = Utils.filterList(moduleTypes, listModuleTypes);
            }
            return Printer.printModuleTypes(listModuleTypes);
        }
        return "There are no Module Types available!";
    }

    private Collection<Rule> getRuleByFilter(Map<String, String> list) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        if (!list.isEmpty()) {
            Rule r = null;
            String uid = list.get(this.id);
            if (uid != null) {
                r = this.autoCommands.getRule(uid);
                if (r != null) {
                    rules.add(r);
                    return rules;
                }
            } else {
                r = this.autoCommands.getRule(this.id);
                if (r != null) {
                    rules.add(r);
                    return rules;
                }
                for (String ruleUID : list.values()) {
                    if (ruleUID.indexOf(this.id) <= -1) continue;
                    rules.add(this.autoCommands.getRule(ruleUID));
                }
            }
        }
        return rules;
    }

    private Collection<RuleTemplate> getTemplateByFilter(Map<String, String> list) {
        ArrayList<RuleTemplate> templates = new ArrayList<RuleTemplate>();
        RuleTemplate t = null;
        String uid = list.get(this.id);
        if (uid != null) {
            t = this.autoCommands.getTemplate(uid, this.locale);
            if (t != null) {
                templates.add(t);
                return templates;
            }
        } else {
            t = this.autoCommands.getTemplate(this.id, this.locale);
            if (t != null) {
                templates.add(t);
                return templates;
            }
            for (String templateUID : list.keySet()) {
                if (templateUID.indexOf(this.id) == -1) continue;
                templates.add(this.autoCommands.getTemplate(templateUID, this.locale));
            }
        }
        return templates;
    }

    private Collection<ModuleType> getModuleTypeByFilter(Map<String, String> list) {
        ArrayList<ModuleType> moduleTypes = new ArrayList<ModuleType>();
        if (!list.isEmpty()) {
            ModuleType mt = null;
            String uid = list.get(this.id);
            if (uid != null) {
                mt = this.autoCommands.getModuleType(uid, this.locale);
                if (mt != null) {
                    moduleTypes.add(mt);
                    return moduleTypes;
                }
            } else {
                mt = this.autoCommands.getModuleType(this.id, this.locale);
                if (mt != null) {
                    moduleTypes.add(mt);
                    return moduleTypes;
                }
                for (String typeUID : list.values()) {
                    if (typeUID.indexOf(this.id) == -1) continue;
                    moduleTypes.add(this.autoCommands.getModuleType(typeUID, this.locale));
                }
            }
        }
        return moduleTypes;
    }

    private void addCollection(Collection collection, Map list) {
        if (collection != null && !collection.isEmpty()) {
            for (Object element : collection) {
                if (element instanceof ModuleType) {
                    list.put(((ModuleType)element).getUID(), element);
                }
                if (element instanceof RuleTemplate) {
                    list.put(((RuleTemplate)element).getUID(), element);
                }
                if (!(element instanceof Rule)) continue;
                list.put(((Rule)element).getUID(), element);
            }
        }
    }
}

