/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.internal;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public final class Connection {
    private final @Nullable String outputModuleId;
    private final @Nullable String outputName;
    private final @Nullable String reference;
    private final String inputName;

    public Connection(String inputName, String reference) {
        this(inputName, null, null, Objects.requireNonNull(reference, "Configuration Reference can't be null."));
    }

    public Connection(String inputName, @Nullable String outputModuleId, @Nullable String outputName, @Nullable String reference) {
        this.inputName = Objects.requireNonNull(inputName, "Input name can't be null.");
        if (inputName.isEmpty()) {
            throw new IllegalArgumentException("Invalid name for Input.");
        }
        this.outputName = outputName;
        this.outputModuleId = outputModuleId;
        this.reference = reference;
    }

    public @Nullable String getOutputModuleId() {
        return this.outputModuleId;
    }

    public @Nullable String getOutputName() {
        return this.outputName;
    }

    public String getInputName() {
        return this.inputName;
    }

    public @Nullable String getReference() {
        return this.reference;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[");
        if (this.outputModuleId != null) {
            sb.append(this.outputModuleId);
            sb.append(".");
            sb.append(this.outputName);
        }
        if (this.reference != null) {
            sb.append("(");
            sb.append(this.reference);
            sb.append(")");
        }
        sb.append("->");
        sb.append(this.inputName);
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.toString().hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Connection other = (Connection)obj;
        if (!this.inputName.equals(other.inputName)) {
            return false;
        }
        if (this.outputModuleId == null ? other.outputModuleId != null : !this.outputModuleId.equals(other.outputModuleId)) {
            return false;
        }
        if (this.outputName == null ? other.outputName != null : !this.outputName.equals(other.outputName)) {
            return false;
        }
        return !(this.reference == null ? other.reference != null : !this.reference.equals(other.reference));
    }
}

