/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.Rule;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.core.internal.Connection;
import org.eclipse.smarthome.automation.type.ActionType;
import org.eclipse.smarthome.automation.type.ConditionType;
import org.eclipse.smarthome.automation.type.Input;
import org.eclipse.smarthome.automation.type.ModuleTypeRegistry;
import org.eclipse.smarthome.automation.type.Output;
import org.eclipse.smarthome.automation.type.TriggerType;

public class ConnectionValidator {
    public static final String CONFIG_REFERENCE_PATTERN = "\\${1}\\{{1}[A-Za-z0-9_-]+\\}{1}|\\${1}[A-Za-z0-9_-]+";
    public static final String OUTPUT_REFERENCE_PATTERN = "(\\[{1}\\\"{1}.+\\\"{1}\\]{1}|\\[{1}\\d+\\]{1}|\\.{1}[^\\[\\]][A-Za-z0-9_-]+[^\\]\\[\\.])*";
    public static final String MODULE_OUTPUT_PATTERN = "[A-Za-z0-9_-]+\\.{1}[A-Za-z0-9_-]+(\\[{1}\\\"{1}.+\\\"{1}\\]{1}|\\[{1}\\d+\\]{1}|\\.{1}[^\\[\\]][A-Za-z0-9_-]+[^\\]\\[\\.])*";
    public static final String CONNECTION_PATTERN = "\\${1}\\{{1}[A-Za-z0-9_-]+\\}{1}|\\${1}[A-Za-z0-9_-]+|[A-Za-z0-9_-]+\\.{1}[A-Za-z0-9_-]+(\\[{1}\\\"{1}.+\\\"{1}\\]{1}|\\[{1}\\d+\\]{1}|\\.{1}[^\\[\\]][A-Za-z0-9_-]+[^\\]\\[\\.])*";

    public static void validateConnections(ModuleTypeRegistry mtRegistry, Rule r) {
        if (r == null) {
            throw new IllegalArgumentException("Validation of rule has failed! Rule must not be null!");
        }
        ConnectionValidator.validateConnections(mtRegistry, r.getTriggers(), r.getConditions(), r.getActions());
    }

    public static void validateConnections(ModuleTypeRegistry mtRegistry, @NonNull List<? extends @NonNull Trigger> triggers, @NonNull List<? extends @NonNull Condition> conditions, @NonNull List<? extends @NonNull Action> actions) {
        if (!triggers.isEmpty()) {
            for (Condition condition : conditions) {
                ConnectionValidator.validateConditionConnections(mtRegistry, condition, triggers);
            }
        }
        if (!triggers.isEmpty()) {
            for (Action action : actions) {
                ConnectionValidator.validateActionConnections(mtRegistry, action, triggers, actions);
            }
        }
    }

    private static void validateActionConnections(ModuleTypeRegistry mtRegistry, Action action, @NonNull List<? extends @NonNull Trigger> triggers, @NonNull List<? extends @NonNull Action> actions) {
        ActionType type = (ActionType)mtRegistry.get((Object)action.getTypeUID());
        if (type == null) {
            throw new IllegalArgumentException("Action Type \"" + action.getTypeUID() + "\" does not exist!");
        }
        List inputs = type.getInputs();
        Set<Connection> cons = ConnectionValidator.getConnections(action.getInputs());
        HashMap<String, Connection> connectionsMap = new HashMap<String, Connection>();
        for (Connection connection : cons) {
            String inputName = connection.getInputName();
            connectionsMap.put(inputName, connection);
        }
        if (inputs != null && !inputs.isEmpty()) {
            for (Input input : inputs) {
                String name = input.getName();
                Connection connection = (Connection)connectionsMap.get(name);
                if (connection == null && input.isRequired()) {
                    throw new IllegalArgumentException("Required input \"" + name + "\" of the condition \"" + action.getId() + "\" not connected");
                }
                if (connection == null) continue;
                ConnectionValidator.checkConnection(mtRegistry, connection, input, triggers, actions);
            }
        }
    }

    private static void checkConnection(ModuleTypeRegistry mtRegistry, Connection connection, Input input, @NonNull List<? extends @NonNull Trigger> triggers, @NonNull List<? extends @NonNull Action> actions) {
        HashMap<String, Action> actionsMap = new HashMap<String, Action>();
        for (Action action : actions) {
            actionsMap.put(action.getId(), action);
        }
        String string = connection.getOutputModuleId();
        Action action = (Action)actionsMap.get(string);
        String msg = " Invalid Connection \"" + connection.getInputName() + "\" : ";
        if (string != null && action != null) {
            String typeUID = action.getTypeUID();
            ActionType actionType = (ActionType)mtRegistry.get((Object)typeUID);
            if (actionType == null) {
                throw new IllegalArgumentException(String.valueOf(msg) + " Action Type with UID \"" + typeUID + "\" does not exist!");
            }
            ConnectionValidator.checkCompatibility(msg, connection, input, actionType.getOutputs());
        } else {
            ConnectionValidator.checkConnection(mtRegistry, connection, input, triggers);
        }
    }

    private static void validateConditionConnections(ModuleTypeRegistry mtRegistry, @NonNull Condition condition, @NonNull List<? extends @NonNull Trigger> triggers) {
        ConditionType type = (ConditionType)mtRegistry.get((Object)condition.getTypeUID());
        if (type == null) {
            throw new IllegalArgumentException("Condition Type \"" + condition.getTypeUID() + "\" does not exist!");
        }
        List inputs = type.getInputs();
        Set<Connection> cons = ConnectionValidator.getConnections(condition.getInputs());
        HashMap<String, Connection> connectionsMap = new HashMap<String, Connection>();
        for (Connection connection : cons) {
            String inputName = connection.getInputName();
            connectionsMap.put(inputName, connection);
        }
        if (inputs != null && !inputs.isEmpty()) {
            for (Input input : inputs) {
                String name = input.getName();
                Connection connection = (Connection)connectionsMap.get(name);
                if (connection != null) {
                    ConnectionValidator.checkConnection(mtRegistry, connection, input, triggers);
                    continue;
                }
                if (!input.isRequired()) continue;
                throw new IllegalArgumentException("Required input \"" + name + "\" of the condition \"" + condition.getId() + "\" not connected");
            }
        }
    }

    private static void checkConnection(ModuleTypeRegistry mtRegistry, Connection connection, Input input, @NonNull List<? extends @NonNull Trigger> triggers) {
        HashMap<String, Trigger> triggersMap = new HashMap<String, Trigger>();
        for (Trigger trigger : triggers) {
            triggersMap.put(trigger.getId(), trigger);
        }
        String string = connection.getOutputModuleId();
        String msg = " Invalid Connection \"" + connection.getInputName() + "\" : ";
        if (string != null) {
            Trigger trigger = (Trigger)triggersMap.get(string);
            if (trigger == null) {
                throw new IllegalArgumentException(String.valueOf(msg) + " Trigger with ID \"" + string + "\" does not exist!");
            }
            String triggerTypeUID = trigger.getTypeUID();
            TriggerType triggerType = (TriggerType)mtRegistry.get((Object)triggerTypeUID);
            if (triggerType == null) {
                throw new IllegalArgumentException(String.valueOf(msg) + " Trigger Type with UID \"" + triggerTypeUID + "\" does not exist!");
            }
            ConnectionValidator.checkCompatibility(msg, connection, input, triggerType.getOutputs());
        }
    }

    private static void checkCompatibility(String msg, Connection connection, Input input, List<Output> outputs) {
        if (connection.getReference() != null) {
            return;
        }
        String outputName = connection.getOutputName();
        if (outputs != null && !outputs.isEmpty()) {
            for (Output output : outputs) {
                if (!output.getName().equals(outputName)) continue;
                if (input.getType().equals("*")) {
                    return;
                }
                try {
                    Class<?> outputType = Class.forName(output.getType());
                    Class<?> inputType = Class.forName(input.getType());
                    if (inputType.isAssignableFrom(outputType)) {
                        return;
                    }
                    throw new IllegalArgumentException(String.valueOf(msg) + " Incompatible types : \"" + output.getType() + "\" and \"" + input.getType() + "\".");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (output.getType().equals(input.getType())) {
                        return;
                    }
                    throw new IllegalArgumentException(String.valueOf(msg) + " Incompatible types : \"" + output.getType() + "\" and \"" + input.getType() + "\".");
                }
            }
            throw new IllegalArgumentException(String.valueOf(msg) + " Output with name \"" + outputName + "\" not exists in the ModuleImpl with ID \"" + connection.getOutputModuleId() + "\"");
        }
    }

    public static Set<Connection> getConnections(Map<String, String> inputs) {
        HashSet<Connection> connections = new HashSet<Connection>();
        for (Map.Entry<String, String> input : inputs.entrySet()) {
            String inputName = input.getKey();
            String reference = input.getValue();
            Connection connection = ConnectionValidator.getConnection(inputName, reference);
            connections.add(connection);
        }
        return connections;
    }

    private static Connection getConnection(String inputName, String reference) {
        if (reference == null || !Pattern.matches(CONNECTION_PATTERN, reference)) {
            throw new IllegalArgumentException("Wrong format of Connection : " + inputName + ": " + reference);
        }
        if (Pattern.matches(CONFIG_REFERENCE_PATTERN, reference)) {
            return new Connection(inputName, reference);
        }
        if (!Pattern.matches(MODULE_OUTPUT_PATTERN, reference)) {
            throw new IllegalArgumentException("Wrong format of Connection : " + inputName + ": " + reference);
        }
        Pattern pattern = Pattern.compile("\\.|\\[");
        String[] referenceTokens = pattern.split(reference, 3);
        String outputModuleId = referenceTokens[0];
        String outputName = referenceTokens[1];
        if (referenceTokens.length == 3) {
            return new Connection(inputName, outputModuleId, outputName, reference.substring(reference.indexOf(outputName) + outputName.length()));
        }
        return new Connection(inputName, outputModuleId, outputName, null);
    }
}

