/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.internal;

import java.security.AccessController;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.smarthome.automation.RuleStatus;
import org.eclipse.smarthome.automation.RuleStatusInfo;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.core.internal.RuleEngineImpl;
import org.eclipse.smarthome.automation.handler.TriggerHandlerCallback;

public class TriggerHandlerCallbackImpl
implements TriggerHandlerCallback {
    private final String ruleUID;
    private ExecutorService executor;
    private Future<?> future;
    private final RuleEngineImpl re;

    protected TriggerHandlerCallbackImpl(RuleEngineImpl re, String ruleUID) {
        this.re = re;
        this.ruleUID = ruleUID;
        this.executor = Executors.newSingleThreadExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggered(Trigger trigger, Map<String, ?> outputs) {
        TriggerHandlerCallbackImpl triggerHandlerCallbackImpl = this;
        synchronized (triggerHandlerCallbackImpl) {
            if (this.executor == null) {
                return;
            }
            this.future = this.executor.submit(new TriggerData(trigger, outputs));
        }
        this.re.logger.debug("The trigger '{}' of rule '{}' is triggered.", (Object)trigger.getId(), (Object)this.ruleUID);
    }

    public boolean isRunning() {
        Future<?> future = this.future;
        return future == null || !future.isDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        TriggerHandlerCallbackImpl triggerHandlerCallbackImpl = this;
        synchronized (triggerHandlerCallbackImpl) {
            AccessController.doPrivileged(() -> {
                this.executor.shutdownNow();
                return null;
            });
            this.executor = null;
        }
    }

    public Boolean isEnabled(String ruleUID) {
        return this.re.isEnabled(ruleUID);
    }

    public void setEnabled(String uid, boolean isEnabled) {
        this.re.setEnabled(uid, isEnabled);
    }

    public RuleStatusInfo getStatusInfo(String ruleUID) {
        return this.re.getStatusInfo(ruleUID);
    }

    public RuleStatus getStatus(String ruleUID) {
        return this.re.getStatus(ruleUID);
    }

    public void runNow(String uid) {
        this.re.runNow(uid);
    }

    public void runNow(String uid, boolean considerConditions, Map<String, Object> context) {
        this.re.runNow(uid, considerConditions, context);
    }

    class TriggerData
    implements Runnable {
        private final Trigger trigger;
        private final Map<String, ?> outputs;

        public Trigger getTrigger() {
            return this.trigger;
        }

        public Map<String, ?> getOutputs() {
            return this.outputs;
        }

        public TriggerData(Trigger t, Map<String, ?> outputs) {
            this.trigger = t;
            this.outputs = outputs;
        }

        @Override
        public void run() {
            TriggerHandlerCallbackImpl.this.re.runRule(TriggerHandlerCallbackImpl.this.ruleUID, this);
        }
    }
}

