/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.internal.composite;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.core.internal.composite.AbstractCompositeModuleHandler;
import org.eclipse.smarthome.automation.core.util.ReferenceResolver;
import org.eclipse.smarthome.automation.handler.ActionHandler;
import org.eclipse.smarthome.automation.type.CompositeActionType;
import org.eclipse.smarthome.automation.type.Output;

public class CompositeActionHandler
extends AbstractCompositeModuleHandler<Action, CompositeActionType, ActionHandler>
implements ActionHandler {
    public static final String REFERENCE = "reference";
    private final Map<String, Output> compositeOutputs;

    public CompositeActionHandler(Action action, CompositeActionType mt, LinkedHashMap<Action, ActionHandler> mapModuleToHandler, String ruleUID) {
        super(action, mt, mapModuleToHandler);
        this.compositeOutputs = this.getCompositeOutputMap(((CompositeActionType)this.moduleType).getOutputs());
    }

    public Map<String, Object> execute(Map<String, Object> context) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<Action> children = this.getChildren();
        Map<String, Object> compositeContext = this.getCompositeContext(context);
        for (Action child : children) {
            Map<String, Object> childContext;
            ActionHandler childHandler = (ActionHandler)this.moduleHandlerMap.get(child);
            Map childResults = childHandler.execute(childContext = Collections.unmodifiableMap(this.getChildContext((Module)child, compositeContext)));
            if (childResults == null) continue;
            for (Map.Entry childResult : childResults.entrySet()) {
                String childOuputName = String.valueOf(child.getId()) + "." + (String)childResult.getKey();
                Output output = this.compositeOutputs.get(childOuputName);
                if (output == null) continue;
                String childOuputRef = output.getReference();
                if (childOuputRef != null && childOuputRef.length() > childOuputName.length()) {
                    childOuputRef = childOuputRef.substring(childOuputName.length());
                    result.put(output.getName(), ReferenceResolver.resolveComplexDataReference(childResult.getValue(), childOuputRef));
                    continue;
                }
                result.put(output.getName(), childResult.getValue());
            }
        }
        return result.size() > 0 ? result : null;
    }

    protected Map<String, Output> getCompositeOutputMap(List<Output> outputs) {
        HashMap<String, Output> result = new HashMap<String, Output>(11);
        if (outputs != null) {
            for (Output output : outputs) {
                String refs = output.getReference();
                if (refs == null) continue;
                StringTokenizer st = new StringTokenizer(refs, ",");
                while (st.hasMoreTokens()) {
                    int j;
                    String ref = st.nextToken().trim();
                    int i = ref.indexOf(46);
                    if (i != -1 && (j = ReferenceResolver.getNextRefToken(ref, i + 1)) != -1) {
                        ref = ref.substring(0, j);
                    }
                    result.put(ref, output);
                }
            }
        }
        return result;
    }

    @Override
    protected List<Action> getChildren() {
        return ((CompositeActionType)this.moduleType).getChildren();
    }
}

