/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.type.ModuleType;
import org.eclipse.smarthome.automation.type.ModuleTypeRegistry;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.ConfigUtil;
import org.eclipse.smarthome.config.core.Configuration;

public class ConfigurationNormalizer {
    public static <T extends Module> void normalizeModuleConfigurations(List<T> modules, ModuleTypeRegistry mtRegistry) {
        for (Module module : modules) {
            ModuleType mt = (ModuleType)mtRegistry.get((Object)module.getTypeUID());
            if (mt == null) continue;
            Map<String, ConfigDescriptionParameter> mapConfigDescriptions = ConfigurationNormalizer.getConfigDescriptionMap(mt.getConfigurationDescriptions());
            ConfigurationNormalizer.normalizeConfiguration(module.getConfiguration(), mapConfigDescriptions);
        }
    }

    public static Map<String, ConfigDescriptionParameter> getConfigDescriptionMap(List<ConfigDescriptionParameter> configDesc) {
        HashMap<String, ConfigDescriptionParameter> mapConfigDescs = new HashMap<String, ConfigDescriptionParameter>();
        for (ConfigDescriptionParameter configDescriptionParameter : configDesc) {
            mapConfigDescs.put(configDescriptionParameter.getName(), configDescriptionParameter);
        }
        return mapConfigDescs;
    }

    public static void normalizeConfiguration(Configuration configuration, Map<String, ConfigDescriptionParameter> configDescriptionMap) {
        for (Map.Entry<String, ConfigDescriptionParameter> entry : configDescriptionMap.entrySet()) {
            ConfigDescriptionParameter parameter = entry.getValue();
            if (parameter == null) continue;
            String parameterName = entry.getKey();
            Object value = configuration.get(parameterName);
            String defaultValue = parameter.getDefault();
            if (value instanceof String && ((String)value).contains("${")) continue;
            if (value == null) {
                if (defaultValue == null) {
                    configuration.remove(parameterName);
                    continue;
                }
                configuration.put(parameterName, ConfigUtil.normalizeType((Object)defaultValue, (ConfigDescriptionParameter)parameter));
                continue;
            }
            configuration.put(parameterName, ConfigUtil.normalizeType((Object)value, (ConfigDescriptionParameter)parameter));
        }
    }
}

