/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.core.factory;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.handler.BaseModuleHandlerFactory;
import org.eclipse.smarthome.automation.handler.ModuleHandler;
import org.eclipse.smarthome.automation.handler.ModuleHandlerFactory;
import org.eclipse.smarthome.automation.module.core.handler.ChannelEventTriggerHandler;
import org.eclipse.smarthome.automation.module.core.handler.CompareConditionHandler;
import org.eclipse.smarthome.automation.module.core.handler.GenericEventConditionHandler;
import org.eclipse.smarthome.automation.module.core.handler.GenericEventTriggerHandler;
import org.eclipse.smarthome.automation.module.core.handler.ItemCommandActionHandler;
import org.eclipse.smarthome.automation.module.core.handler.ItemCommandTriggerHandler;
import org.eclipse.smarthome.automation.module.core.handler.ItemStateConditionHandler;
import org.eclipse.smarthome.automation.module.core.handler.ItemStateTriggerHandler;
import org.eclipse.smarthome.automation.module.core.handler.RuleEnablementActionHandler;
import org.eclipse.smarthome.automation.module.core.handler.RunRuleActionHandler;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class CoreModuleHandlerFactory
extends BaseModuleHandlerFactory
implements ModuleHandlerFactory {
    private final Logger logger = LoggerFactory.getLogger(CoreModuleHandlerFactory.class);
    private static final Collection<String> TYPES = Arrays.asList("core.ItemCommandTrigger", "core.ItemStateUpdateTrigger", "core.ItemStateChangeTrigger", "core.ItemStateCondition", "core.ItemCommandAction", "core.GenericEventTrigger", "core.ChannelEventTrigger", "core.GenericEventCondition", "core.GenericEventCondition", "core.GenericCompareCondition", "core.RuleEnablementAction", "core.RunRuleAction");
    private ItemRegistry itemRegistry;
    private EventPublisher eventPublisher;
    private BundleContext bundleContext;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Deactivate
    protected void deactivate() {
        super.deactivate();
    }

    public Collection<String> getTypes() {
        return TYPES;
    }

    @Reference
    protected void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
        for (ModuleHandler handler : this.getHandlers().values()) {
            if (handler instanceof ItemStateConditionHandler) {
                ((ItemStateConditionHandler)handler).setItemRegistry(this.itemRegistry);
                continue;
            }
            if (!(handler instanceof ItemCommandActionHandler)) continue;
            ((ItemCommandActionHandler)handler).setItemRegistry(this.itemRegistry);
        }
    }

    protected void unsetItemRegistry(ItemRegistry itemRegistry) {
        for (ModuleHandler handler : this.getHandlers().values()) {
            if (handler instanceof ItemStateConditionHandler) {
                ((ItemStateConditionHandler)handler).unsetItemRegistry(this.itemRegistry);
                continue;
            }
            if (!(handler instanceof ItemCommandActionHandler)) continue;
            ((ItemCommandActionHandler)handler).unsetItemRegistry(this.itemRegistry);
        }
        this.itemRegistry = null;
    }

    @Reference
    protected void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        for (ModuleHandler handler : this.getHandlers().values()) {
            if (!(handler instanceof ItemCommandActionHandler)) continue;
            ((ItemCommandActionHandler)handler).setEventPublisher(eventPublisher);
        }
    }

    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
        for (ModuleHandler handler : this.getHandlers().values()) {
            if (!(handler instanceof ItemCommandActionHandler)) continue;
            ((ItemCommandActionHandler)handler).unsetEventPublisher(eventPublisher);
        }
    }

    protected synchronized ModuleHandler internalCreate(Module module, String ruleUID) {
        this.logger.trace("create {} -> {} : {}", new Object[]{module.getId(), module.getTypeUID(), ruleUID});
        String moduleTypeUID = module.getTypeUID();
        if (module instanceof Trigger) {
            if ("core.GenericEventTrigger".equals(moduleTypeUID)) {
                return new GenericEventTriggerHandler((Trigger)module, this.bundleContext);
            }
            if ("core.ChannelEventTrigger".equals(moduleTypeUID)) {
                return new ChannelEventTriggerHandler((Trigger)module, this.bundleContext);
            }
            if ("core.ItemCommandTrigger".equals(moduleTypeUID)) {
                return new ItemCommandTriggerHandler((Trigger)module, this.bundleContext);
            }
            if ("core.ItemStateChangeTrigger".equals(moduleTypeUID) || "core.ItemStateUpdateTrigger".equals(moduleTypeUID)) {
                return new ItemStateTriggerHandler((Trigger)module, this.bundleContext);
            }
        } else if (module instanceof Condition) {
            if ("core.ItemStateCondition".equals(moduleTypeUID)) {
                ItemStateConditionHandler handler = new ItemStateConditionHandler((Condition)module);
                handler.setItemRegistry(this.itemRegistry);
                return handler;
            }
            if ("core.GenericEventCondition".equals(moduleTypeUID)) {
                return new GenericEventConditionHandler((Condition)module);
            }
            if ("core.GenericCompareCondition".equals(moduleTypeUID)) {
                return new CompareConditionHandler((Condition)module);
            }
        } else if (module instanceof Action) {
            if ("core.ItemCommandAction".equals(moduleTypeUID)) {
                ItemCommandActionHandler postCommandActionHandler = new ItemCommandActionHandler((Action)module);
                postCommandActionHandler.setEventPublisher(this.eventPublisher);
                postCommandActionHandler.setItemRegistry(this.itemRegistry);
                return postCommandActionHandler;
            }
            if ("core.RuleEnablementAction".equals(moduleTypeUID)) {
                return new RuleEnablementActionHandler((Action)module);
            }
            if ("core.RunRuleAction".equals(moduleTypeUID)) {
                return new RunRuleActionHandler((Action)module);
            }
        }
        this.logger.error("The ModuleHandler is not supported:{}", (Object)moduleTypeUID);
        return null;
    }
}

