/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.core.handler;

import java.util.List;
import java.util.Map;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.handler.ActionHandler;
import org.eclipse.smarthome.automation.handler.BaseModuleHandler;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.items.events.ItemCommandEvent;
import org.eclipse.smarthome.core.items.events.ItemEventFactory;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.TypeParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemCommandActionHandler
extends BaseModuleHandler<Action>
implements ActionHandler {
    private final Logger logger = LoggerFactory.getLogger(ItemCommandActionHandler.class);
    public static final String ITEM_COMMAND_ACTION = "core.ItemCommandAction";
    private static final String ITEM_NAME = "itemName";
    private static final String COMMAND = "command";
    private ItemRegistry itemRegistry;
    private EventPublisher eventPublisher;

    public ItemCommandActionHandler(Action module) {
        super((Module)module);
    }

    public void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    public void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
    }

    public void dispose() {
        this.eventPublisher = null;
        this.itemRegistry = null;
    }

    public Map<String, Object> execute(Map<String, Object> inputs) {
        block8: {
            String itemName = (String)((Action)this.module).getConfiguration().get(ITEM_NAME);
            String command = (String)((Action)this.module).getConfiguration().get(COMMAND);
            if (itemName != null && this.eventPublisher != null && this.itemRegistry != null) {
                try {
                    Item item = this.itemRegistry.getItem(itemName);
                    Command commandObj = null;
                    Object cmd = inputs.get(COMMAND);
                    if (cmd instanceof Command) {
                        if (item.getAcceptedCommandTypes().contains(cmd.getClass())) {
                            commandObj = (Command)cmd;
                        }
                    } else {
                        commandObj = TypeParser.parseCommand((List)item.getAcceptedCommandTypes(), (String)command);
                    }
                    if (commandObj != null) {
                        ItemCommandEvent itemCommandEvent = ItemEventFactory.createCommandEvent((String)itemName, (Command)commandObj);
                        this.logger.debug("Executing ItemCommandAction on Item {} with Command {}", (Object)itemCommandEvent.getItemName(), (Object)itemCommandEvent.getItemCommand());
                        this.eventPublisher.post((Event)itemCommandEvent);
                        break block8;
                    }
                    this.logger.warn("Command '{}' is not valid for item '{}'.", (Object)command, (Object)itemName);
                }
                catch (ItemNotFoundException itemNotFoundException) {
                    this.logger.error("Item with name {} not found in ItemRegistry.", (Object)itemName);
                }
            } else {
                this.logger.error("Command was not posted because either the configuration was not correct or a service was missing: ItemName: {}, Command: {}, eventPublisher: {}, ItemRegistry: {}", new Object[]{itemName, command, this.eventPublisher, this.itemRegistry});
            }
        }
        return null;
    }
}

