/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.media.internal;

import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.automation.Visibility;
import org.eclipse.smarthome.automation.type.ActionType;
import org.eclipse.smarthome.automation.type.ModuleType;
import org.eclipse.smarthome.automation.type.ModuleTypeProvider;
import org.eclipse.smarthome.config.core.ConfigConstants;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameterBuilder;
import org.eclipse.smarthome.config.core.ParameterOption;
import org.eclipse.smarthome.core.audio.AudioManager;
import org.eclipse.smarthome.core.audio.AudioSink;
import org.eclipse.smarthome.core.common.registry.ProviderChangeListener;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class MediaActionTypeProvider
implements ModuleTypeProvider {
    private AudioManager audioManager;

    public ModuleType getModuleType(String UID, Locale locale) {
        if ("media.PlayAction".equals(UID)) {
            return this.getPlayActionType(locale);
        }
        if ("media.SayAction".equals(UID)) {
            return this.getSayActionType(locale);
        }
        return null;
    }

    public Collection<ModuleType> getModuleTypes(Locale locale) {
        return Stream.of(this.getPlayActionType(locale), this.getSayActionType(locale)).collect(Collectors.toList());
    }

    private ModuleType getPlayActionType(Locale locale) {
        return new ActionType("media.PlayAction", this.getConfigPlayDesc(locale), "play a sound", "Plays a sound file.", null, Visibility.VISIBLE, new ArrayList(), new ArrayList());
    }

    private ModuleType getSayActionType(Locale locale) {
        return new ActionType("media.SayAction", this.getConfigSayDesc(locale), "say something", "Speaks a given text through a natural voice.", null, Visibility.VISIBLE, new ArrayList(), new ArrayList());
    }

    private List<ConfigDescriptionParameter> getConfigPlayDesc(Locale locale) {
        ConfigDescriptionParameter param1 = ConfigDescriptionParameterBuilder.create((String)"sound", (ConfigDescriptionParameter.Type)ConfigDescriptionParameter.Type.TEXT).withRequired(Boolean.valueOf(true)).withLabel("Sound").withDescription("the sound to play").withOptions(this.getSoundOptions()).withLimitToOptions(Boolean.valueOf(true)).build();
        return Stream.of(param1, this.getAudioSinkConfigDescParam(locale)).collect(Collectors.toList());
    }

    private List<ConfigDescriptionParameter> getConfigSayDesc(Locale locale) {
        ConfigDescriptionParameter param1 = ConfigDescriptionParameterBuilder.create((String)"text", (ConfigDescriptionParameter.Type)ConfigDescriptionParameter.Type.TEXT).withRequired(Boolean.valueOf(true)).withLabel("Text").withDescription("the text to speak").build();
        return Stream.of(param1, this.getAudioSinkConfigDescParam(locale)).collect(Collectors.toList());
    }

    private ConfigDescriptionParameter getAudioSinkConfigDescParam(Locale locale) {
        ConfigDescriptionParameter param2 = ConfigDescriptionParameterBuilder.create((String)"sink", (ConfigDescriptionParameter.Type)ConfigDescriptionParameter.Type.TEXT).withRequired(Boolean.valueOf(false)).withLabel("Sink").withDescription("the audio sink id").withOptions(this.getSinkOptions(locale)).withLimitToOptions(Boolean.valueOf(true)).build();
        return param2;
    }

    private List<ParameterOption> getSoundOptions() {
        ArrayList<ParameterOption> options = new ArrayList<ParameterOption>();
        File soundsDir = Paths.get(ConfigConstants.getConfigFolder(), "sounds").toFile();
        if (soundsDir.isDirectory()) {
            String[] stringArray = soundsDir.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                if (fileName.contains(".") && !fileName.startsWith(".")) {
                    String soundName = StringUtils.capitalize((String)fileName.substring(0, fileName.lastIndexOf(".")));
                    options.add(new ParameterOption(fileName, soundName));
                }
                ++n2;
            }
        }
        return options;
    }

    private List<ParameterOption> getSinkOptions(Locale locale) {
        ArrayList<ParameterOption> options = new ArrayList<ParameterOption>();
        for (AudioSink sink : this.audioManager.getAllSinks()) {
            options.add(new ParameterOption(sink.getId(), sink.getLabel(locale)));
        }
        return options;
    }

    public void addProviderChangeListener(ProviderChangeListener<ModuleType> listener) {
    }

    public Collection<ModuleType> getAll() {
        return this.getModuleTypes(null);
    }

    public void removeProviderChangeListener(ProviderChangeListener<ModuleType> listener) {
    }

    @Reference
    protected void setAudioManager(AudioManager audioManager) {
        this.audioManager = audioManager;
    }

    protected void unsetAudioManager(AudioManager audioManager) {
        this.audioManager = null;
    }
}

