/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.script.internal;

import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.automation.module.script.ScriptEngineContainer;
import org.eclipse.smarthome.automation.module.script.ScriptEngineFactory;
import org.eclipse.smarthome.automation.module.script.ScriptEngineManager;
import org.eclipse.smarthome.automation.module.script.internal.GenericScriptEngineFactory;
import org.eclipse.smarthome.automation.module.script.internal.ScriptExtensionManager;
import org.eclipse.smarthome.automation.module.script.internal.ScriptExtensionManagerWrapper;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={ScriptEngineManager.class})
public class ScriptEngineManagerImpl
implements ScriptEngineManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Set<ScriptEngineFactory> scriptEngineFactories = new HashSet<ScriptEngineFactory>();
    private HashMap<String, @Nullable ScriptEngineContainer> loadedScriptEngineInstances = new HashMap();
    private HashMap<String, @Nullable ScriptEngineFactory> supportedLanguages = new HashMap();
    private GenericScriptEngineFactory genericScriptEngineFactory = new GenericScriptEngineFactory();
    @NonNullByDefault(value={})
    private ScriptExtensionManager scriptExtensionManager;

    @Reference
    public void setScriptExtensionManager(ScriptExtensionManager scriptExtensionManager) {
        this.scriptExtensionManager = scriptExtensionManager;
    }

    public void unsetScriptExtensionManager(ScriptExtensionManager scriptExtensionManager) {
        this.scriptExtensionManager = null;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addScriptEngineFactory(ScriptEngineFactory provider) {
        this.scriptEngineFactories.add(provider);
        for (String language : provider.getLanguages()) {
            this.supportedLanguages.put(language, provider);
        }
    }

    public void removeScriptEngineFactory(ScriptEngineFactory provider) {
        this.scriptEngineFactories.remove(provider);
        for (String language : provider.getLanguages()) {
            this.supportedLanguages.remove(language, provider);
        }
    }

    @Override
    public boolean isSupported(String fileExtension) {
        return this.findEngineFactory(fileExtension) != null;
    }

    @Override
    public @Nullable ScriptEngineContainer createScriptEngine(String fileExtension, String scriptIdentifier) {
        ScriptEngineContainer result = null;
        ScriptEngineFactory engineProvider = this.findEngineFactory(fileExtension);
        if (engineProvider == null) {
            this.logger.error("loadScript(): scriptengine for language '{}' could not be found for identifier: {}", (Object)fileExtension, (Object)scriptIdentifier);
        } else {
            try {
                ScriptEngine engine = engineProvider.createScriptEngine(fileExtension);
                HashMap<String, Object> scriptExManager = new HashMap<String, Object>();
                result = new ScriptEngineContainer(engine, engineProvider, scriptIdentifier);
                ScriptExtensionManagerWrapper wrapper = new ScriptExtensionManagerWrapper(this.scriptExtensionManager, result);
                scriptExManager.put("scriptExtension", wrapper);
                scriptExManager.put("se", wrapper);
                engineProvider.scopeValues(engine, scriptExManager);
                this.scriptExtensionManager.importDefaultPresets(engineProvider, engine, scriptIdentifier);
                this.loadedScriptEngineInstances.put(scriptIdentifier, result);
            }
            catch (Exception ex) {
                this.logger.error("Error while creating ScriptEngine", (Throwable)ex);
                this.removeScriptExtensions(scriptIdentifier);
            }
        }
        return result;
    }

    @Override
    public void loadScript(String scriptIdentifier, InputStreamReader scriptData) {
        ScriptEngineContainer container = this.loadedScriptEngineInstances.get(scriptIdentifier);
        if (container == null) {
            this.logger.error("could not load script as no engine is created");
        } else {
            ScriptEngine engine = container.getScriptEngine();
            try {
                engine.eval(scriptData);
                if (engine instanceof Invocable) {
                    Invocable inv = (Invocable)((Object)engine);
                    try {
                        inv.invokeFunction("scriptLoaded", scriptIdentifier);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        this.logger.trace("scriptLoaded() not defined in script: {}", (Object)scriptIdentifier);
                    }
                } else {
                    this.logger.trace("engine does not support Invocable interface");
                }
            }
            catch (Exception ex) {
                this.logger.error("Error during evaluation of script '{}': {}", (Object)scriptIdentifier, (Object)ex.getMessage());
            }
        }
    }

    @Override
    public void removeEngine(String scriptIdentifier) {
        ScriptEngineContainer container = this.loadedScriptEngineInstances.get(scriptIdentifier);
        if (container != null) {
            if (container.getScriptEngine() instanceof Invocable) {
                Invocable inv = (Invocable)((Object)container.getScriptEngine());
                try {
                    inv.invokeFunction("scriptUnloaded", new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    this.logger.trace("scriptUnloaded() not defined in script");
                }
                catch (ScriptException e) {
                    this.logger.error("Error while executing script", (Throwable)e);
                }
            } else {
                this.logger.trace("engine does not support Invocable interface");
            }
            this.removeScriptExtensions(scriptIdentifier);
        }
    }

    private void removeScriptExtensions(String pathIdentifier) {
        try {
            this.scriptExtensionManager.dispose(pathIdentifier);
        }
        catch (Exception ex) {
            this.logger.error("error removing engine", (Throwable)ex);
        }
    }

    private @Nullable ScriptEngineFactory findEngineFactory(String fileExtension) {
        ScriptEngineFactory engineProvider = this.supportedLanguages.get(fileExtension);
        if (engineProvider != null) {
            return engineProvider;
        }
        for (ScriptEngineFactory provider : this.supportedLanguages.values()) {
            if (provider == null || !provider.isSupported(fileExtension)) continue;
            return provider;
        }
        if (this.genericScriptEngineFactory.isSupported(fileExtension)) {
            return this.genericScriptEngineFactory;
        }
        return null;
    }
}

