/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.script.internal.handler;

import java.util.Map;
import java.util.Optional;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.handler.ConditionHandler;
import org.eclipse.smarthome.automation.module.script.ScriptEngineManager;
import org.eclipse.smarthome.automation.module.script.internal.handler.AbstractScriptModuleHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptConditionHandler
extends AbstractScriptModuleHandler<Condition>
implements ConditionHandler {
    public final Logger logger = LoggerFactory.getLogger(ScriptConditionHandler.class);
    public static final String SCRIPT_CONDITION = "script.ScriptCondition";

    public ScriptConditionHandler(Condition module, String ruleUID, ScriptEngineManager scriptEngineManager) {
        super(module, ruleUID, scriptEngineManager);
    }

    public boolean isSatisfied(Map<String, Object> context) {
        boolean result = false;
        Optional<ScriptEngine> engine = this.getScriptEngine();
        if (engine.isPresent()) {
            ScriptEngine scriptEngine = engine.get();
            this.setExecutionContext(scriptEngine, context);
            try {
                Object returnVal = scriptEngine.eval(this.script);
                if (returnVal instanceof Boolean) {
                    result = (Boolean)returnVal;
                } else {
                    this.logger.error("Script did not return a boolean value, but '{}'", (Object)returnVal.toString());
                }
            }
            catch (ScriptException e) {
                this.logger.error("Script execution failed: {}", (Object)e.getMessage());
            }
        }
        return result;
    }
}

