/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.timer.handler;

import java.text.MessageFormat;
import org.eclipse.smarthome.automation.ModuleHandlerCallback;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.handler.BaseTriggerModuleHandler;
import org.eclipse.smarthome.automation.handler.TriggerHandlerCallback;
import org.eclipse.smarthome.core.scheduler.CronScheduler;
import org.eclipse.smarthome.core.scheduler.ScheduledCompletableFuture;
import org.eclipse.smarthome.core.scheduler.SchedulerRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeOfDayTriggerHandler
extends BaseTriggerModuleHandler
implements SchedulerRunnable {
    private final Logger logger = LoggerFactory.getLogger(TimeOfDayTriggerHandler.class);
    public static final String MODULE_TYPE_ID = "timer.TimeOfDayTrigger";
    public static final String MODULE_CONTEXT_NAME = "MODULE";
    private static final String CFG_TIME = "time";
    private final CronScheduler scheduler;
    private final String expression;
    private ScheduledCompletableFuture<Void> schedule;

    public TimeOfDayTriggerHandler(Trigger module, CronScheduler scheduler) {
        super(module);
        this.scheduler = scheduler;
        String time = module.getConfiguration().get(CFG_TIME).toString();
        try {
            String[] parts = time.split(":");
            this.expression = MessageFormat.format("* {1} {0} * * *", Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            throw new IllegalArgumentException("'time' parameter '" + time + "' is not in valid format 'hh:mm'.", e);
        }
    }

    public synchronized void setCallback(ModuleHandlerCallback callback) {
        super.setCallback(callback);
        this.scheduleJob();
    }

    private void scheduleJob() {
        this.schedule = this.scheduler.schedule((SchedulerRunnable)this, this.expression);
        this.logger.debug("Scheduled job for trigger '{}' at '{}' each day.", (Object)((Trigger)this.module).getId(), ((Trigger)this.module).getConfiguration().get(CFG_TIME));
    }

    public void run() {
        ((TriggerHandlerCallback)this.callback).triggered((Trigger)this.module, null);
    }

    public synchronized void dispose() {
        super.dispose();
        if (this.schedule != null) {
            this.schedule.cancel(true);
            this.logger.debug("cancelled job for trigger '{}'.", (Object)((Trigger)this.module).getId());
        }
    }
}

