/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.parser.gson.internal;

import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.smarthome.automation.Rule;
import org.eclipse.smarthome.automation.core.dto.RuleDTOMapper;
import org.eclipse.smarthome.automation.dto.RuleDTO;
import org.eclipse.smarthome.automation.parser.Parser;
import org.eclipse.smarthome.automation.parser.ParsingException;
import org.eclipse.smarthome.automation.parser.ParsingNestedException;
import org.eclipse.smarthome.automation.parser.gson.internal.AbstractGSONParser;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={Parser.class}, property={"parser.type=parser.rule", "format=json"})
public class RuleGSONParser
extends AbstractGSONParser<Rule> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<Rule> parse(InputStreamReader reader) throws ParsingException {
        JsonReader jr;
        block13: {
            HashSet<Rule> hashSet;
            jr = new JsonReader((Reader)reader);
            try {
                HashSet<Rule> rules = new HashSet<Rule>();
                if (!jr.hasNext()) break block13;
                JsonToken token = jr.peek();
                if (JsonToken.BEGIN_ARRAY.equals((Object)token)) {
                    List ruleDtos = (List)gson.fromJson(jr, new TypeToken<List<RuleDTO>>(){}.getType());
                    for (RuleDTO ruleDto : ruleDtos) {
                        rules.add(RuleDTOMapper.map((RuleDTO)ruleDto));
                    }
                } else {
                    RuleDTO ruleDto = (RuleDTO)gson.fromJson(jr, RuleDTO.class);
                    rules.add(RuleDTOMapper.map((RuleDTO)ruleDto));
                }
                hashSet = rules;
            }
            catch (Exception e) {
                try {
                    throw new ParsingException(new ParsingNestedException(3, null, (Throwable)e));
                }
                catch (Throwable throwable) {
                    try {
                        jr.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                jr.close();
                return hashSet;
            }
            catch (IOException iOException) {}
            return hashSet;
        }
        try {
            jr.close();
            return Collections.emptySet();
        }
        catch (IOException iOException) {}
        return Collections.emptySet();
    }
}

