/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.astro.internal.calc;

import java.util.Calendar;
import org.eclipse.smarthome.binding.astro.internal.model.Season;
import org.eclipse.smarthome.binding.astro.internal.model.SeasonName;
import org.eclipse.smarthome.binding.astro.internal.util.DateTimeUtils;

public class SeasonCalc {
    private int currentYear;
    private Season currentSeason;

    public Season getSeason(Calendar calendar, double latitude) {
        int year = calendar.get(1);
        boolean isSouthernHemisphere = latitude < 0.0;
        Season season = this.currentSeason;
        if (this.currentYear != year) {
            season = new Season();
            if (!isSouthernHemisphere) {
                season.setSpring(this.calcEquiSol(0, year));
                season.setSummer(this.calcEquiSol(1, year));
                season.setAutumn(this.calcEquiSol(2, year));
                season.setWinter(this.calcEquiSol(3, year));
            } else {
                season.setSpring(this.calcEquiSol(2, year));
                season.setSummer(this.calcEquiSol(3, year));
                season.setAutumn(this.calcEquiSol(0, year));
                season.setWinter(this.calcEquiSol(1, year));
            }
            this.currentSeason = season;
            this.currentYear = year;
        }
        season.setName(!isSouthernHemisphere ? this.getCurrentSeasonNameNorthern(calendar) : this.getCurrentSeasonNameSouthern(calendar));
        return season;
    }

    private SeasonName getCurrentSeasonNameNorthern(Calendar calendar) {
        long currentMillis = calendar.getTimeInMillis();
        if (currentMillis < this.currentSeason.getSpring().getTimeInMillis() || currentMillis >= this.currentSeason.getWinter().getTimeInMillis()) {
            return SeasonName.WINTER;
        }
        if (currentMillis >= this.currentSeason.getSpring().getTimeInMillis() && currentMillis < this.currentSeason.getSummer().getTimeInMillis()) {
            return SeasonName.SPRING;
        }
        if (currentMillis >= this.currentSeason.getSummer().getTimeInMillis() && currentMillis < this.currentSeason.getAutumn().getTimeInMillis()) {
            return SeasonName.SUMMER;
        }
        if (currentMillis >= this.currentSeason.getAutumn().getTimeInMillis() && currentMillis < this.currentSeason.getWinter().getTimeInMillis()) {
            return SeasonName.AUTUMN;
        }
        return null;
    }

    private SeasonName getCurrentSeasonNameSouthern(Calendar calendar) {
        long currentMillis = calendar.getTimeInMillis();
        if (currentMillis < this.currentSeason.getAutumn().getTimeInMillis() || currentMillis >= this.currentSeason.getSummer().getTimeInMillis()) {
            return SeasonName.SUMMER;
        }
        if (currentMillis >= this.currentSeason.getAutumn().getTimeInMillis() && currentMillis < this.currentSeason.getWinter().getTimeInMillis()) {
            return SeasonName.AUTUMN;
        }
        if (currentMillis >= this.currentSeason.getWinter().getTimeInMillis() && currentMillis < this.currentSeason.getSpring().getTimeInMillis()) {
            return SeasonName.WINTER;
        }
        if (currentMillis >= this.currentSeason.getSpring().getTimeInMillis() && currentMillis < this.currentSeason.getSummer().getTimeInMillis()) {
            return SeasonName.SPRING;
        }
        return null;
    }

    private Calendar calcEquiSol(int season, int year) {
        double estimate = this.calcInitial(season, year);
        double t = (estimate - 2451545.0) / 36525.0;
        double w = 35999.373 * t - 2.47;
        double dl = 1.0 + 0.0334 * this.cosDeg(w) + 7.0E-4 * this.cosDeg(2.0 * w);
        double s = this.periodic24(t);
        double julianDate = estimate + 1.0E-5 * s / dl;
        return DateTimeUtils.toCalendar(julianDate);
    }

    private double calcInitial(int season, int year) {
        double y = (double)(year - 2000) / 1000.0;
        switch (season) {
            case 0: {
                return 2451623.80984 + 365242.37404 * y + 0.05169 * Math.pow(y, 2.0) - 0.00411 * Math.pow(y, 3.0) - 5.7E-4 * Math.pow(y, 4.0);
            }
            case 1: {
                return 2451716.56767 + 365241.62603 * y + 0.00325 * Math.pow(y, 2.0) + 0.00888 * Math.pow(y, 3.0) - 3.0E-4 * Math.pow(y, 4.0);
            }
            case 2: {
                return 2451810.21715 + 365242.01767 * y - 0.11575 * Math.pow(y, 2.0) + 0.00337 * Math.pow(y, 3.0) + 7.8E-4 * Math.pow(y, 4.0);
            }
            case 3: {
                return 2451900.05952 + 365242.74049 * y - 0.06223 * Math.pow(y, 2.0) - 0.00823 * Math.pow(y, 3.0) + 3.2E-4 * Math.pow(y, 4.0);
            }
        }
        return 0.0;
    }

    private double periodic24(double T) {
        int[] a = new int[]{485, 203, 199, 182, 156, 136, 77, 74, 70, 58, 52, 50, 45, 44, 29, 18, 17, 16, 14, 12, 12, 12, 9, 8};
        double[] b = new double[]{324.96, 337.23, 342.08, 27.85, 73.14, 171.52, 222.54, 296.72, 243.58, 119.81, 297.17, 21.02, 247.54, 325.15, 60.93, 155.12, 288.79, 198.04, 199.76, 95.39, 287.11, 320.81, 227.73, 15.45};
        double[] c = new double[]{1934.136, 32964.467, 20.186, 445267.112, 45036.886, 22518.443, 65928.934, 3034.906, 9037.513, 33718.147, 150.678, 2281.226, 29929.562, 31555.956, 4443.417, 67555.328, 4562.452, 62894.029, 31436.921, 14577.848, 31931.756, 34777.259, 1222.114, 16859.074};
        double result = 0.0;
        int i = 0;
        while (i < 24) {
            result += (double)a[i] * this.cosDeg(b[i] + c[i] * T);
            ++i;
        }
        return result;
    }

    private double cosDeg(double deg) {
        return Math.cos(deg * Math.PI / 180.0);
    }
}

