/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.astro.internal.calc;

import java.util.Calendar;
import java.util.Map;
import org.apache.commons.lang.time.DateUtils;
import org.eclipse.smarthome.binding.astro.internal.calc.MoonCalc;
import org.eclipse.smarthome.binding.astro.internal.calc.SeasonCalc;
import org.eclipse.smarthome.binding.astro.internal.calc.SunZodiacCalc;
import org.eclipse.smarthome.binding.astro.internal.model.Position;
import org.eclipse.smarthome.binding.astro.internal.model.Radiation;
import org.eclipse.smarthome.binding.astro.internal.model.Range;
import org.eclipse.smarthome.binding.astro.internal.model.Sun;
import org.eclipse.smarthome.binding.astro.internal.model.SunEclipse;
import org.eclipse.smarthome.binding.astro.internal.model.SunPhaseName;
import org.eclipse.smarthome.binding.astro.internal.util.DateTimeUtils;

public class SunCalc {
    private static final double J2000 = 2451545.0;
    private static final double SC = 1367.0;
    public static final double DEG2RAD = Math.PI / 180;
    public static final double RAD2DEG = 57.29577951308232;
    private static final double M0 = 6.240059966692059;
    private static final double M1 = 0.017201969994578018;
    private static final double J0 = 9.0E-4;
    private static final double J1 = 0.0053;
    private static final double J2 = -0.0069;
    private static final double C1 = 0.033419564517187424;
    private static final double C2 = 3.4906585039886593E-4;
    private static final double C3 = 5.235987755982989E-6;
    private static final double P = 1.796593062783907;
    private static final double E = 0.4092797095926703;
    private static final double TH0 = 4.889714432387314;
    private static final double TH1 = 6.3003876824396166;
    private static final double SUN_ANGLE = -0.83;
    private static final double SUN_DIAMETER = 0.009250245035569947;
    private static final double H0 = -0.014486232791552934;
    private static final double H1 = -0.10471975511965978;
    private static final double H2 = -0.20943951023931956;
    private static final double H3 = -0.3141592653589793;
    private static final double MINUTES_PER_DAY = 1440.0;
    private static final int CURVE_TIME_INTERVAL = 20;
    private static final double JD_ONE_MINUTE_FRACTION = 6.944444444444445E-4;

    public void setPositionalInfo(Calendar calendar, double latitude, double longitude, Double altitude, Sun sun) {
        double lw = -longitude * (Math.PI / 180);
        double phi = latitude * (Math.PI / 180);
        double j = DateTimeUtils.dateToJulianDate(calendar);
        double m = this.getSolarMeanAnomaly(j);
        double c = this.getEquationOfCenter(m);
        double lsun = this.getEclipticLongitude(m, c);
        double d = this.getSunDeclination(lsun);
        double a = this.getRightAscension(lsun);
        double th = this.getSiderealTime(j, lw);
        double azimuth = this.getAzimuth(th, a, phi, d) / (Math.PI / 180);
        double elevation = this.getElevation(th, a, phi, d) / (Math.PI / 180);
        double shadeLength = this.getShadeLength(elevation);
        Position position = sun.getPosition();
        position.setAzimuth(azimuth + 180.0);
        position.setElevation(elevation);
        position.setShadeLength(shadeLength);
        this.setRadiationInfo(calendar, elevation, altitude, sun);
    }

    public void setRadiationInfo(Calendar calendar, double elevation, Double altitude, Sun sun) {
        double sinAlpha = Math.sin(Math.PI / 180 * elevation);
        int dayOfYear = calendar.get(6);
        int daysInYear = calendar.getActualMaximum(6);
        double rOut = elevation > 3.0 ? 1367.0 * (0.034 * Math.cos(Math.PI / 180 * (double)(360 * dayOfYear / daysInYear)) + 1.0) : 0.0;
        double altitudeRatio = altitude != null ? 1.0 / Math.pow(1.0 - 0.022569444444444444 * (altitude / 1000.0), 5.256) : 1.0;
        double m = (Math.sqrt(1229.0 + Math.pow(614.0 * sinAlpha, 2.0)) - 614.0 * sinAlpha) * altitudeRatio;
        double rDir = rOut * Math.pow(0.6, m) * sinAlpha;
        double rDiff = rOut * (0.271 - 0.294 * Math.pow(0.6, m)) * sinAlpha;
        double rTot = rDir + rDiff;
        Radiation radiation = sun.getRadiation();
        radiation.setDirect(rDir);
        radiation.setDiffuse(rDiff);
        radiation.setTotal(rTot);
    }

    private boolean isSunUpAllDay(Calendar calendar, double latitude, double longitude, Double altitude) {
        Calendar cal = DateTimeUtils.truncateToMidnight(calendar);
        Sun sun = new Sun();
        int minutes = 0;
        while ((double)minutes <= 1440.0) {
            this.setPositionalInfo(cal, latitude, longitude, altitude, sun);
            if (sun.getPosition().getElevationAsDouble() < -0.83) {
                return false;
            }
            cal.add(12, 20);
            minutes += 20;
        }
        return true;
    }

    public Sun getSunInfo(Calendar calendar, double latitude, double longitude, Double altitude) {
        return this.getSunInfo(calendar, latitude, longitude, altitude, false);
    }

    private Sun getSunInfo(Calendar calendar, double latitude, double longitude, Double altitude, boolean onlyAstro) {
        double lw = -longitude * (Math.PI / 180);
        double phi = latitude * (Math.PI / 180);
        double j = DateTimeUtils.midnightDateToJulianDate(calendar) + 0.5;
        double n = this.getJulianCycle(j, lw);
        double js = this.getApproxSolarTransit(0.0, lw, n);
        double m = this.getSolarMeanAnomaly(js);
        double c = this.getEquationOfCenter(m);
        double lsun = this.getEclipticLongitude(m, c);
        double d = this.getSunDeclination(lsun);
        double jtransit = this.getSolarTransit(js, m, lsun);
        double w0 = this.getHourAngle(-0.014486232791552934, phi, d);
        double w1 = this.getHourAngle(-0.005235987755982987, phi, d);
        double jset = this.getSunsetJulianDate(w0, m, lsun, lw, n);
        double jsetstart = this.getSunsetJulianDate(w1, m, lsun, lw, n);
        double jrise = this.getSunriseJulianDate(jtransit, jset);
        double jriseend = this.getSunriseJulianDate(jtransit, jsetstart);
        double w2 = this.getHourAngle(-0.10471975511965978, phi, d);
        double jnau = this.getSunsetJulianDate(w2, m, lsun, lw, n);
        double jciv2 = this.getSunriseJulianDate(jtransit, jnau);
        double w3 = this.getHourAngle(-0.20943951023931956, phi, d);
        double w4 = this.getHourAngle(-0.3141592653589793, phi, d);
        double jastro = this.getSunsetJulianDate(w3, m, lsun, lw, n);
        double jdark = this.getSunsetJulianDate(w4, m, lsun, lw, n);
        double jnau2 = this.getSunriseJulianDate(jtransit, jastro);
        double jastro2 = this.getSunriseJulianDate(jtransit, jdark);
        Sun sun = new Sun();
        sun.setAstroDawn(new Range(DateTimeUtils.toCalendar(jastro2), DateTimeUtils.toCalendar(jnau2)));
        sun.setAstroDusk(new Range(DateTimeUtils.toCalendar(jastro), DateTimeUtils.toCalendar(jdark)));
        if (onlyAstro) {
            return sun;
        }
        sun.setNoon(new Range(DateTimeUtils.toCalendar(jtransit), DateTimeUtils.toCalendar(jtransit + 6.944444444444445E-4)));
        sun.setRise(new Range(DateTimeUtils.toCalendar(jrise), DateTimeUtils.toCalendar(jriseend)));
        sun.setSet(new Range(DateTimeUtils.toCalendar(jsetstart), DateTimeUtils.toCalendar(jset)));
        sun.setCivilDawn(new Range(DateTimeUtils.toCalendar(jciv2), DateTimeUtils.toCalendar(jrise)));
        sun.setCivilDusk(new Range(DateTimeUtils.toCalendar(jset), DateTimeUtils.toCalendar(jnau)));
        sun.setNauticDawn(new Range(DateTimeUtils.toCalendar(jnau2), DateTimeUtils.toCalendar(jciv2)));
        sun.setNauticDusk(new Range(DateTimeUtils.toCalendar(jnau), DateTimeUtils.toCalendar(jastro)));
        boolean isSunUpAllDay = this.isSunUpAllDay(calendar, latitude, longitude, altitude);
        Range daylightRange = new Range();
        if (sun.getRise().getStart() == null && sun.getRise().getEnd() == null) {
            if (isSunUpAllDay) {
                daylightRange = new Range(DateTimeUtils.truncateToMidnight(calendar), DateTimeUtils.truncateToMidnight(this.addDays(calendar, 1)));
            }
        } else {
            daylightRange = new Range(sun.getRise().getEnd(), sun.getSet().getStart());
        }
        sun.setDaylight(daylightRange);
        Sun sunYesterday = this.getSunInfo(this.addDays(calendar, -1), latitude, longitude, altitude, true);
        Range morningNightRange = null;
        morningNightRange = sunYesterday.getAstroDusk().getEnd() != null && DateUtils.isSameDay((Calendar)sunYesterday.getAstroDusk().getEnd(), (Calendar)calendar) ? new Range(sunYesterday.getAstroDusk().getEnd(), sun.getAstroDawn().getStart()) : (isSunUpAllDay || sun.getAstroDawn().getStart() == null ? new Range() : new Range(DateTimeUtils.truncateToMidnight(calendar), sun.getAstroDawn().getStart()));
        sun.setMorningNight(morningNightRange);
        Range eveningNightRange = null;
        eveningNightRange = sun.getAstroDusk().getEnd() != null && DateUtils.isSameDay((Calendar)sun.getAstroDusk().getEnd(), (Calendar)calendar) ? new Range(sun.getAstroDusk().getEnd(), DateTimeUtils.truncateToMidnight(this.addDays(calendar, 1))) : new Range();
        sun.setEveningNight(eveningNightRange);
        if (isSunUpAllDay) {
            sun.setNight(new Range());
        } else {
            Sun sunTomorrow = this.getSunInfo(this.addDays(calendar, 1), latitude, longitude, altitude, true);
            sun.setNight(new Range(sun.getAstroDusk().getEnd(), sunTomorrow.getAstroDawn().getStart()));
        }
        SunEclipse eclipse = sun.getEclipse();
        MoonCalc mc = new MoonCalc();
        double partial = mc.getEclipse(calendar, 0.0, j, 0);
        eclipse.setPartial(DateTimeUtils.toCalendar(partial));
        double ring = mc.getEclipse(calendar, 0.0, j, 2);
        eclipse.setRing(DateTimeUtils.toCalendar(ring));
        double total = mc.getEclipse(calendar, 0.0, j, 1);
        eclipse.setTotal(DateTimeUtils.toCalendar(total));
        SunZodiacCalc zodiacCalc = new SunZodiacCalc();
        sun.setZodiac(zodiacCalc.getZodiac(calendar));
        SeasonCalc seasonCalc = new SeasonCalc();
        sun.setSeason(seasonCalc.getSeason(calendar, latitude));
        for (Map.Entry<SunPhaseName, Range> rangeEntry : sun.getAllRanges().entrySet()) {
            SunPhaseName entryPhase = rangeEntry.getKey();
            if (!rangeEntry.getValue().matches(Calendar.getInstance())) continue;
            if (entryPhase == SunPhaseName.MORNING_NIGHT || entryPhase == SunPhaseName.EVENING_NIGHT) {
                sun.getPhase().setName(SunPhaseName.NIGHT);
                continue;
            }
            sun.getPhase().setName(entryPhase);
        }
        return sun;
    }

    private Calendar addDays(Calendar calendar, int days) {
        Calendar cal = (Calendar)calendar.clone();
        cal.add(5, days);
        return cal;
    }

    private double getJulianCycle(double j, double lw) {
        return Math.round(j - 2451545.0 - 9.0E-4 - lw / (Math.PI * 2));
    }

    private double getApproxSolarTransit(double ht, double lw, double n) {
        return 2451545.0009 + (ht + lw) / (Math.PI * 2) + n;
    }

    private double getSolarMeanAnomaly(double js) {
        return 6.240059966692059 + 0.017201969994578018 * (js - 2451545.0);
    }

    private double getEquationOfCenter(double m) {
        return 0.033419564517187424 * Math.sin(m) + 3.4906585039886593E-4 * Math.sin(2.0 * m) + 5.235987755982989E-6 * Math.sin(3.0 * m);
    }

    private double getEclipticLongitude(double m, double c) {
        return m + 1.796593062783907 + c + Math.PI;
    }

    private double getSolarTransit(double js, double m, double lsun) {
        return js + 0.0053 * Math.sin(m) + -0.0069 * Math.sin(2.0 * lsun);
    }

    private double getSunDeclination(double lsun) {
        return Math.asin(Math.sin(lsun) * Math.sin(0.4092797095926703));
    }

    private double getRightAscension(double lsun) {
        return Math.atan2(Math.sin(lsun) * Math.cos(0.4092797095926703), Math.cos(lsun));
    }

    private double getSiderealTime(double j, double lw) {
        return 4.889714432387314 + 6.3003876824396166 * (j - 2451545.0) - lw;
    }

    private double getAzimuth(double th, double a, double phi, double d) {
        double h = th - a;
        return Math.atan2(Math.sin(h), Math.cos(h) * Math.sin(phi) - Math.tan(d) * Math.cos(phi));
    }

    private double getElevation(double th, double a, double phi, double d) {
        return Math.asin(Math.sin(phi) * Math.sin(d) + Math.cos(phi) * Math.cos(d) * Math.cos(th - a));
    }

    private double getShadeLength(double elevation) {
        return 1.0 / Math.tan(elevation * (Math.PI / 180));
    }

    private double getHourAngle(double h, double phi, double d) {
        return Math.acos((Math.sin(h) - Math.sin(phi) * Math.sin(d)) / (Math.cos(phi) * Math.cos(d)));
    }

    private double getSunsetJulianDate(double w0, double m, double Lsun, double lw, double n) {
        return this.getSolarTransit(this.getApproxSolarTransit(w0, lw, n), m, Lsun);
    }

    private double getSunriseJulianDate(double jtransit, double jset) {
        return jtransit - (jset - jtransit);
    }
}

