/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.astro.internal.calc;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.smarthome.binding.astro.internal.model.SunZodiac;
import org.eclipse.smarthome.binding.astro.internal.model.ZodiacSign;
import org.eclipse.smarthome.binding.astro.internal.util.DateTimeUtils;

public class SunZodiacCalc {
    private Map<Integer, List<SunZodiac>> zodiacsByYear = new HashMap<Integer, List<SunZodiac>>();

    public SunZodiac getZodiac(Calendar calendar) {
        int year = calendar.get(1);
        List<SunZodiac> zodiacs = this.zodiacsByYear.get(year);
        if (zodiacs == null) {
            zodiacs = this.calculateZodiacs(year);
            this.zodiacsByYear.clear();
            this.zodiacsByYear.put(year, zodiacs);
        }
        for (SunZodiac zodiac : zodiacs) {
            if (!zodiac.isValid(calendar)) continue;
            return zodiac;
        }
        return null;
    }

    private List<SunZodiac> calculateZodiacs(int year) {
        ArrayList<SunZodiac> zodiacs = new ArrayList<SunZodiac>();
        zodiacs.add(new SunZodiac(ZodiacSign.ARIES, DateTimeUtils.getRange(year, 2, 21, year, 3, 19)));
        zodiacs.add(new SunZodiac(ZodiacSign.TAURUS, DateTimeUtils.getRange(year, 3, 20, year, 4, 20)));
        zodiacs.add(new SunZodiac(ZodiacSign.GEMINI, DateTimeUtils.getRange(year, 4, 21, year, 5, 20)));
        zodiacs.add(new SunZodiac(ZodiacSign.CANCER, DateTimeUtils.getRange(year, 5, 21, year, 6, 22)));
        zodiacs.add(new SunZodiac(ZodiacSign.LEO, DateTimeUtils.getRange(year, 6, 23, year, 7, 22)));
        zodiacs.add(new SunZodiac(ZodiacSign.VIRGO, DateTimeUtils.getRange(year, 7, 23, year, 8, 22)));
        zodiacs.add(new SunZodiac(ZodiacSign.LIBRA, DateTimeUtils.getRange(year, 8, 23, year, 9, 22)));
        zodiacs.add(new SunZodiac(ZodiacSign.SCORPIO, DateTimeUtils.getRange(year, 9, 23, year, 10, 21)));
        zodiacs.add(new SunZodiac(ZodiacSign.SAGITTARIUS, DateTimeUtils.getRange(year, 10, 22, year, 11, 21)));
        zodiacs.add(new SunZodiac(ZodiacSign.CAPRICORN, DateTimeUtils.getRange(year, 11, 22, year + 1, 0, 19)));
        zodiacs.add(new SunZodiac(ZodiacSign.CAPRICORN, DateTimeUtils.getRange(year - 1, 11, 22, year, 0, 19)));
        zodiacs.add(new SunZodiac(ZodiacSign.AQUARIUS, DateTimeUtils.getRange(year, 0, 20, year, 1, 18)));
        zodiacs.add(new SunZodiac(ZodiacSign.PISCES, DateTimeUtils.getRange(year, 1, 19, year, 2, 20)));
        return zodiacs;
    }
}

