/**
 * Copyright (c) 2014,2019 Contributors to the Eclipse Foundation
 *
 * See the NOTICE file(s) distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0
 *
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.gap;

import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.BlueGigaCommand;

/**
 * Class to implement the BlueGiga command <b>setAdvParameters</b>.
 * <p>
 * This command is used to set the advertising parameters. Example: If the minimum
 * advertisement interval is 40ms and the maximum advertisement interval is 100ms then the
 * real advertisement interval will be mostly the middle value (70ms) plus a randomly added
 * 20ms delay, which needs to be added according to the Bluetooth specification.
 * <p>
 * This class provides methods for processing BlueGiga API commands.
 * <p>
 * Note that this code is autogenerated. Manual changes may be overwritten.
 *
 * @author Chris Jackson - Initial contribution of Java code generator
 */
public class BlueGigaSetAdvParametersCommand extends BlueGigaCommand {
    public static int COMMAND_CLASS = 0x06;
    public static int COMMAND_METHOD = 0x08;

    /**
     * Minimum advertisement interval in units of 625us. Range: 0x20 to 0x4000. Default: 0x200
     * (320ms) Explanation: 0x200 = 512 512 * 625us = 320000us = 320ms
     * <p>
     * BlueGiga API type is <i>uint16</i> - Java type is {@link int}
     */
    private int advIntervalMin;

    /**
     * Maximum advertisement interval in units of 625us. Range: 0x20 to 0x4000. Default: 0x200
     * (320ms)
     * <p>
     * BlueGiga API type is <i>uint16</i> - Java type is {@link int}
     */
    private int advIntervalMax;

    /**
     * A bit mask to identify which of the three advertisement channels are used. Examples: 0x07:
     * All three channels are used 0x03: Advertisement channels 37 and 38 are used. 0x04: Only
     * advertisement channel 39 is used
     * <p>
     * BlueGiga API type is <i>uint8</i> - Java type is {@link int}
     */
    private int advChannels;

    /**
     * Minimum advertisement interval in units of 625us. Range: 0x20 to 0x4000. Default: 0x200
     * (320ms) Explanation: 0x200 = 512 512 * 625us = 320000us = 320ms
     *
     * @param advIntervalMin the advIntervalMin to set as {@link int}
     */
    public void setAdvIntervalMin(int advIntervalMin) {
        this.advIntervalMin = advIntervalMin;
    }
    /**
     * Maximum advertisement interval in units of 625us. Range: 0x20 to 0x4000. Default: 0x200
     * (320ms)
     *
     * @param advIntervalMax the advIntervalMax to set as {@link int}
     */
    public void setAdvIntervalMax(int advIntervalMax) {
        this.advIntervalMax = advIntervalMax;
    }
    /**
     * A bit mask to identify which of the three advertisement channels are used. Examples: 0x07:
     * All three channels are used 0x03: Advertisement channels 37 and 38 are used. 0x04: Only
     * advertisement channel 39 is used
     *
     * @param advChannels the advChannels to set as {@link int}
     */
    public void setAdvChannels(int advChannels) {
        this.advChannels = advChannels;
    }

    @Override
    public int[] serialize() {
        // Serialize the header
        serializeHeader(COMMAND_CLASS, COMMAND_METHOD);

        // Serialize the fields
        serializeUInt16(advIntervalMin);
        serializeUInt16(advIntervalMax);
        serializeUInt8(advChannels);

        return getPayload();
    }

    @Override
    public String toString() {
        final StringBuilder builder = new StringBuilder();
        builder.append("BlueGigaSetAdvParametersCommand [advIntervalMin=");
        builder.append(advIntervalMin);
        builder.append(", advIntervalMax=");
        builder.append(advIntervalMax);
        builder.append(", advChannels=");
        builder.append(advChannels);
        builder.append(']');
        return builder.toString();
    }
}
