/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bluetooth.bluegiga.handler;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.bluetooth.BluetoothAdapter;
import org.eclipse.smarthome.binding.bluetooth.BluetoothAddress;
import org.eclipse.smarthome.binding.bluetooth.BluetoothDevice;
import org.eclipse.smarthome.binding.bluetooth.BluetoothDeviceListener;
import org.eclipse.smarthome.binding.bluetooth.BluetoothDiscoveryListener;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.BlueGigaBluetoothDevice;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.BlueGigaCommand;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.BlueGigaEventListener;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.BlueGigaHandlerListener;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.BlueGigaResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.BlueGigaSerialHandler;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributeclient.BlueGigaAttributeWriteCommand;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributeclient.BlueGigaAttributeWriteResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributeclient.BlueGigaFindInformationCommand;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributeclient.BlueGigaFindInformationResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributeclient.BlueGigaReadByGroupTypeCommand;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributeclient.BlueGigaReadByGroupTypeResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributeclient.BlueGigaReadByHandleCommand;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributeclient.BlueGigaReadByHandleResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.connection.BlueGigaConnectionStatusEvent;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.connection.BlueGigaDisconnectCommand;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.connection.BlueGigaDisconnectResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.connection.BlueGigaDisconnectedEvent;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.gap.BlueGigaConnectDirectCommand;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.gap.BlueGigaConnectDirectResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.gap.BlueGigaDiscoverCommand;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.gap.BlueGigaEndProcedureCommand;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.gap.BlueGigaEndProcedureResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.gap.BlueGigaScanResponseEvent;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.gap.BlueGigaSetModeCommand;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.gap.BlueGigaSetModeResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.gap.BlueGigaSetScanParametersCommand;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.system.BlueGigaAddressGetCommand;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.system.BlueGigaAddressGetResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.system.BlueGigaGetConnectionsCommand;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.system.BlueGigaGetConnectionsResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.system.BlueGigaGetInfoCommand;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.system.BlueGigaGetInfoResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.enumeration.BgApiResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.enumeration.BluetoothAddressType;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.enumeration.GapConnectableMode;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.enumeration.GapDiscoverMode;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.enumeration.GapDiscoverableMode;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.BaseBridgeHandler;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.io.transport.serial.PortInUseException;
import org.eclipse.smarthome.io.transport.serial.SerialPort;
import org.eclipse.smarthome.io.transport.serial.SerialPortIdentifier;
import org.eclipse.smarthome.io.transport.serial.SerialPortManager;
import org.eclipse.smarthome.io.transport.serial.UnsupportedCommOperationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class BlueGigaBridgeHandler
extends BaseBridgeHandler
implements BluetoothAdapter,
BlueGigaEventListener,
BlueGigaHandlerListener {
    private final Logger logger = LoggerFactory.getLogger(BlueGigaBridgeHandler.class);
    private final SerialPortManager serialPortManager;
    private @Nullable SerialPort serialPort;
    private @Nullable InputStream inputStream;
    private @Nullable OutputStream outputStream;
    private @Nullable BlueGigaSerialHandler bgHandler;
    private int maxConnections = 0;
    private final int passiveScanInterval = 64;
    private final int passiveScanWindow = 8;
    private final int activeScanInterval = 64;
    private final int activeScanWindow = 32;
    private @Nullable BluetoothAddress address;
    private boolean discoveryActive = true;
    private final Map<BluetoothAddress, BluetoothDevice> devices = new ConcurrentHashMap<BluetoothAddress, BluetoothDevice>();
    private final Map<Integer, BluetoothAddress> connections = new ConcurrentHashMap<Integer, BluetoothAddress>();
    protected final Set<BluetoothDiscoveryListener> discoveryListeners = new CopyOnWriteArraySet<BluetoothDiscoveryListener>();
    protected final ConcurrentHashMap<BluetoothAddress, BluetoothDeviceListener> deviceListeners = new ConcurrentHashMap();

    public BlueGigaBridgeHandler(Bridge bridge, SerialPortManager serialPortManager) {
        super(bridge);
        this.serialPortManager = serialPortManager;
    }

    public ThingUID getUID() {
        return this.getThing().getUID();
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
    }

    public void initialize() {
        String portId;
        Object discovery = this.getConfig().get("discovery");
        if (discovery != null && discovery.toString().equalsIgnoreCase(Boolean.FALSE.toString())) {
            this.discoveryActive = false;
            this.logger.debug("Deactivated discovery participation.");
        }
        if ((portId = (String)this.getConfig().get("port")) == null) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "Serial port must be configured!");
            return;
        }
        if (this.openSerialPort(portId, 115200)) {
            BlueGigaSerialHandler bgh = new BlueGigaSerialHandler(this.inputStream, this.outputStream);
            bgh.addEventListener(this);
            bgh.addHandlerListener(this);
            this.setBgHandler(bgh);
            this.updateStatus(ThingStatus.UNKNOWN);
            this.scheduler.submit(() -> {
                this.bgStopProcedure();
                BlueGigaCommand command = new BlueGigaGetConnectionsCommand();
                BlueGigaGetConnectionsResponse connectionsResponse = (BlueGigaGetConnectionsResponse)bgh.sendTransaction(command);
                if (connectionsResponse != null) {
                    this.maxConnections = connectionsResponse.getMaxconn();
                }
                int connection = 0;
                while (connection < this.maxConnections) {
                    this.bgDisconnect(connection);
                    ++connection;
                }
                command = new BlueGigaAddressGetCommand();
                BlueGigaAddressGetResponse addressResponse = (BlueGigaAddressGetResponse)bgh.sendTransaction(command);
                if (addressResponse != null) {
                    this.address = new BluetoothAddress(addressResponse.getAddress());
                    this.updateStatus(ThingStatus.ONLINE);
                } else {
                    this.updateStatus(ThingStatus.OFFLINE);
                }
                command = new BlueGigaGetInfoCommand();
                BlueGigaGetInfoResponse infoResponse = (BlueGigaGetInfoResponse)bgh.sendTransaction(command);
                this.bgSetMode();
                this.bgStartScanning(false, 64, 8);
                Map properties = this.editProperties();
                properties.put("maxconnections", Integer.toString(this.maxConnections));
                properties.put("firmwareVersion", String.format("%d.%d", infoResponse.getMajor(), infoResponse.getMinor()));
                properties.put("hardwareVersion", Integer.toString(infoResponse.getHardware()));
                properties.put("protocol", Integer.toString(infoResponse.getProtocolVersion()));
                properties.put("linklayer", Integer.toString(infoResponse.getLlVersion()));
                this.updateProperties(properties);
            });
        } else {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.OFFLINE.COMMUNICATION_ERROR, "Failed opening serial port.");
        }
    }

    public void dispose() {
        try {
            BlueGigaSerialHandler bgh = this.getBgHandler();
            bgh.removeEventListener(this);
            bgh.removeHandlerListener(this);
            bgh.close();
        }
        catch (IllegalStateException illegalStateException) {}
        this.closeSerialPort();
    }

    private boolean openSerialPort(String serialPortName, int baudRate) {
        SerialPortIdentifier portIdentifier;
        block7: {
            this.logger.debug("Connecting to serial port '{}'", (Object)serialPortName);
            portIdentifier = this.serialPortManager.getIdentifier(serialPortName);
            if (portIdentifier != null) break block7;
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "Port does not exist");
            return false;
        }
        SerialPort sp = portIdentifier.open("org.openhab.binding.bluetooth.bluegiga", 2000);
        sp.setSerialPortParams(baudRate, 8, 1, 0);
        sp.setFlowControlMode(2);
        sp.enableReceiveThreshold(1);
        sp.enableReceiveTimeout(2000);
        sp.notifyOnDataAvailable(true);
        this.logger.info("Connected to serial port '{}'.", (Object)serialPortName);
        try {
            this.inputStream = new BufferedInputStream(sp.getInputStream());
            this.outputStream = sp.getOutputStream();
        }
        catch (IOException e) {
            this.logger.error("Error getting serial streams", (Throwable)e);
            return false;
        }
        try {
            this.serialPort = sp;
            return true;
        }
        catch (PortInUseException portInUseException) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.OFFLINE.CONFIGURATION_ERROR, "Serial Error: Port in use");
            return false;
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.OFFLINE.COMMUNICATION_ERROR, "Serial Error: Unsupported operation");
            return false;
        }
    }

    private void closeSerialPort() {
        if (this.serialPort != null) {
            SerialPort sp = this.serialPort;
            try {
                try {
                    sp.disableReceiveTimeout();
                    sp.removeEventListener();
                    if (this.outputStream != null) {
                        OutputStream os = this.outputStream;
                        os.flush();
                        os.close();
                    }
                    if (this.inputStream != null) {
                        this.inputStream.close();
                    }
                }
                catch (IOException e) {
                    this.logger.error("Error closing serial port.", (Throwable)e);
                    sp.close();
                    this.logger.debug("Closed serial port.");
                    this.serialPort = null;
                    this.inputStream = null;
                    this.outputStream = null;
                }
            }
            finally {
                sp.close();
                this.logger.debug("Closed serial port.");
                this.serialPort = null;
                this.inputStream = null;
                this.outputStream = null;
            }
        }
    }

    @Override
    public void bluegigaEventReceived(@Nullable BlueGigaResponse event) {
        if (event instanceof BlueGigaScanResponseEvent) {
            BlueGigaScanResponseEvent scanEvent = (BlueGigaScanResponseEvent)event;
            BluetoothAddress sender = new BluetoothAddress(scanEvent.getSender());
            if (this.devices.get(sender) == null) {
                this.logger.debug("BlueGiga adding new device to adaptor {}: {}", (Object)this.address, (Object)sender);
                BlueGigaBluetoothDevice device = new BlueGigaBluetoothDevice(this, new BluetoothAddress(scanEvent.getSender()), scanEvent.getAddressType());
                this.devices.put(sender, device);
                this.deviceDiscovered(device);
            }
            return;
        }
        if (event instanceof BlueGigaConnectionStatusEvent) {
            BlueGigaConnectionStatusEvent connectionEvent = (BlueGigaConnectionStatusEvent)event;
            this.connections.put(connectionEvent.getConnection(), new BluetoothAddress(connectionEvent.getAddress()));
        }
        if (event instanceof BlueGigaDisconnectedEvent) {
            BlueGigaDisconnectedEvent disconnectedEvent = (BlueGigaDisconnectedEvent)event;
            this.connections.remove(disconnectedEvent.getConnection());
        }
    }

    public void scanStart() {
        this.bgStopProcedure();
        this.bgStartScanning(true, 64, 32);
        for (BluetoothDevice device : this.devices.values()) {
            this.deviceDiscovered(device);
        }
    }

    public void scanStop() {
        this.bgStopProcedure();
        this.bgStartScanning(false, 64, 8);
    }

    public BluetoothAddress getAddress() {
        BluetoothAddress addr = this.address;
        if (addr != null) {
            return addr;
        }
        throw new IllegalStateException("Adapter has not been initialized yet!");
    }

    public BluetoothDevice getDevice(BluetoothAddress address) {
        BluetoothDevice device = this.devices.get(address);
        if (device == null) {
            device = new BlueGigaBluetoothDevice(this, address, BluetoothAddressType.UNKNOWN);
            this.devices.put(address, device);
        }
        return device;
    }

    public BlueGigaSerialHandler getBgHandler() {
        BlueGigaSerialHandler handler = this.bgHandler;
        if (handler != null) {
            return handler;
        }
        throw new IllegalStateException("bgHandler must not be null at that point!");
    }

    public void setBgHandler(BlueGigaSerialHandler bgHandler) {
        this.bgHandler = bgHandler;
    }

    public boolean bgConnect(BluetoothAddress address, BluetoothAddressType addressType) {
        if (this.connections.containsValue(address)) {
            return false;
        }
        if (this.connections.size() == this.maxConnections + 1) {
            this.logger.debug("BlueGiga: Attempt to connect to {} but no connections available.", (Object)address);
            return false;
        }
        this.bgSetMode();
        int connIntervalMin = 60;
        int connIntervalMax = 100;
        int latency = 0;
        int timeout = 100;
        BlueGigaConnectDirectCommand connect = new BlueGigaConnectDirectCommand();
        connect.setAddress(address.toString());
        connect.setAddrType(addressType);
        connect.setConnIntervalMin(connIntervalMin);
        connect.setConnIntervalMax(connIntervalMax);
        connect.setLatency(latency);
        connect.setTimeout(timeout);
        BlueGigaConnectDirectResponse connectResponse = (BlueGigaConnectDirectResponse)this.getBgHandler().sendTransaction(connect);
        return connectResponse.getResult() == BgApiResponse.SUCCESS;
    }

    public boolean bgDisconnect(int connectionHandle) {
        BlueGigaDisconnectCommand command = new BlueGigaDisconnectCommand();
        command.setConnection(connectionHandle);
        BlueGigaDisconnectResponse response = (BlueGigaDisconnectResponse)this.getBgHandler().sendTransaction(command);
        return response.getResult() == BgApiResponse.SUCCESS;
    }

    public void deviceDiscovered(BluetoothDevice device) {
        if (this.discoveryActive) {
            for (BluetoothDiscoveryListener listener : this.discoveryListeners) {
                listener.deviceDiscovered(device);
            }
        }
    }

    public boolean bgFindPrimaryServices(int connectionHandle) {
        this.logger.debug("BlueGiga FindPrimary: connection {}", (Object)connectionHandle);
        BlueGigaReadByGroupTypeCommand command = new BlueGigaReadByGroupTypeCommand();
        command.setConnection(connectionHandle);
        command.setStart(1);
        command.setEnd(65535);
        command.setUuid(UUID.fromString("00002800-0000-0000-0000-000000000000"));
        BlueGigaReadByGroupTypeResponse response = (BlueGigaReadByGroupTypeResponse)this.getBgHandler().sendTransaction(command);
        return response.getResult() == BgApiResponse.SUCCESS;
    }

    public boolean bgFindCharacteristics(int connectionHandle) {
        this.logger.debug("BlueGiga Find: connection {}", (Object)connectionHandle);
        BlueGigaFindInformationCommand command = new BlueGigaFindInformationCommand();
        command.setConnection(connectionHandle);
        command.setStart(1);
        command.setEnd(65535);
        BlueGigaFindInformationResponse response = (BlueGigaFindInformationResponse)this.getBgHandler().sendTransaction(command);
        return response.getResult() == BgApiResponse.SUCCESS;
    }

    public boolean bgReadCharacteristic(int connectionHandle, int handle) {
        this.logger.debug("BlueGiga Read: connection {}, handle {}", (Object)connectionHandle, (Object)handle);
        BlueGigaReadByHandleCommand command = new BlueGigaReadByHandleCommand();
        command.setConnection(connectionHandle);
        command.setChrHandle(handle);
        BlueGigaReadByHandleResponse response = (BlueGigaReadByHandleResponse)this.getBgHandler().sendTransaction(command);
        return response.getResult() == BgApiResponse.SUCCESS;
    }

    public boolean bgWriteCharacteristic(int connectionHandle, int handle, int[] value) {
        this.logger.debug("BlueGiga Write: connection {}, handle {}", (Object)connectionHandle, (Object)handle);
        BlueGigaAttributeWriteCommand command = new BlueGigaAttributeWriteCommand();
        command.setConnection(connectionHandle);
        command.setAttHandle(handle);
        command.setData(value);
        BlueGigaAttributeWriteResponse response = (BlueGigaAttributeWriteResponse)this.getBgHandler().sendTransaction(command);
        return response.getResult() == BgApiResponse.SUCCESS;
    }

    private boolean bgStopProcedure() {
        BlueGigaEndProcedureCommand command = new BlueGigaEndProcedureCommand();
        BlueGigaEndProcedureResponse response = (BlueGigaEndProcedureResponse)this.getBgHandler().sendTransaction(command);
        return response.getResult() == BgApiResponse.SUCCESS;
    }

    private boolean bgSetMode() {
        BlueGigaSetModeCommand command = new BlueGigaSetModeCommand();
        command.setConnect(GapConnectableMode.GAP_NON_CONNECTABLE);
        command.setDiscover(GapDiscoverableMode.GAP_NON_DISCOVERABLE);
        BlueGigaSetModeResponse response = (BlueGigaSetModeResponse)this.getBgHandler().sendTransaction(command);
        return response.getResult() == BgApiResponse.SUCCESS;
    }

    private void bgStartScanning(boolean active, int interval, int window) {
        BlueGigaSetScanParametersCommand scanCommand = new BlueGigaSetScanParametersCommand();
        scanCommand.setActiveScanning(active);
        scanCommand.setScanInterval(interval);
        scanCommand.setScanWindow(window);
        this.getBgHandler().sendTransaction(scanCommand);
        BlueGigaDiscoverCommand discoverCommand = new BlueGigaDiscoverCommand();
        discoverCommand.setMode(GapDiscoverMode.GAP_DISCOVER_OBSERVATION);
        this.getBgHandler().sendTransaction(discoverCommand);
    }

    public void addEventListener(BlueGigaEventListener listener) {
        this.getBgHandler().addEventListener(listener);
    }

    public void removeEventListener(BlueGigaEventListener listener) {
        this.getBgHandler().removeEventListener(listener);
    }

    public void addDiscoveryListener(BluetoothDiscoveryListener listener) {
        this.discoveryListeners.add(listener);
    }

    public void removeDiscoveryListener(@Nullable BluetoothDiscoveryListener listener) {
        this.discoveryListeners.remove(listener);
    }

    @Override
    public void bluegigaClosed(Exception reason) {
        this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, reason.getMessage());
    }
}

