/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bluetooth.bluegiga.internal;

import java.util.Arrays;
import java.util.UUID;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.BlueGigaPacket;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.enumeration.BluetoothAddressType;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.enumeration.GapConnectableMode;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.enumeration.GapDiscoverMode;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.enumeration.GapDiscoverableMode;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.enumeration.SmpIoCapabilities;

public abstract class BlueGigaCommand
extends BlueGigaPacket {
    protected int[] buffer = new int[131];
    protected int length = 0;

    protected void serializeHeader(int classId, int commandId) {
        this.buffer[this.length++] = 0;
        this.buffer[this.length++] = 0;
        this.buffer[this.length++] = classId;
        this.buffer[this.length++] = commandId;
    }

    protected void serializeUInt8(int val) {
        this.buffer[this.length++] = val & 0xFF;
    }

    protected void serializeBoolean(boolean val) {
        this.buffer[this.length++] = val ? 1 : 0;
    }

    protected void serializeUInt16(int val) {
        this.buffer[this.length++] = val & 0xFF;
        this.buffer[this.length++] = val >> 8 & 0xFF;
    }

    protected void serializeUInt32(long passkey) {
        this.buffer[this.length++] = (int)(passkey & 0xFFL);
        this.buffer[this.length++] = (int)(passkey >> 8 & 0xFFL);
        this.buffer[this.length++] = (int)(passkey >> 16 & 0xFFL);
        this.buffer[this.length++] = (int)(passkey >> 24 & 0xFFL);
    }

    protected void serializeUInt8Array(int[] array) {
        this.serializeUInt8(array.length);
        int[] nArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            int val = nArray[n2];
            this.serializeUInt8(val);
            ++n2;
        }
    }

    protected void serializeUuid(UUID uuid) {
        this.buffer[this.length++] = 2;
        long high = uuid.getMostSignificantBits();
        this.buffer[this.length++] = (int)(high >> 32 & 0xFFL);
        this.buffer[this.length++] = (int)(high >> 40 & 0xFFL);
    }

    protected void serializeAddress(String address) {
        String[] bytes = address.split(":");
        if (bytes.length == 0) {
            this.serializeUInt8(0);
            this.serializeUInt8(0);
            this.serializeUInt8(0);
            this.serializeUInt8(0);
            this.serializeUInt8(0);
            this.serializeUInt8(0);
            return;
        }
        int cnt = 5;
        while (cnt >= 0) {
            this.serializeUInt8(Integer.parseInt(bytes[cnt], 16));
            --cnt;
        }
    }

    protected void serializeSmpIoCapabilities(SmpIoCapabilities capabilities) {
        this.serializeUInt8(capabilities.getKey());
    }

    protected void serializeBluetoothAddressType(BluetoothAddressType addrType) {
        this.serializeUInt8(addrType.getKey());
    }

    protected void serializeGapDiscoverableMode(GapDiscoverableMode mode) {
        this.serializeUInt8(mode.getKey());
    }

    protected void serializeGapConnectableMode(GapConnectableMode mode) {
        this.serializeUInt8(mode.getKey());
    }

    protected void serializeGapDiscoverMode(GapDiscoverMode mode) {
        this.serializeUInt8(mode.getKey());
    }

    protected int[] getPayload() {
        this.buffer[1] = this.length - 4;
        return Arrays.copyOfRange(this.buffer, 0, this.length);
    }

    public abstract int[] serialize();
}

