/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bluetooth.bluegiga.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.BlueGigaResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributeclient.BlueGigaAttributeValueEvent;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributeclient.BlueGigaAttributeWriteResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributeclient.BlueGigaExecuteWriteResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributeclient.BlueGigaFindByTypeValueResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributeclient.BlueGigaFindInformationFoundEvent;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributeclient.BlueGigaFindInformationResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributeclient.BlueGigaGroupFoundEvent;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributeclient.BlueGigaIndicateConfirmResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributeclient.BlueGigaIndicatedEvent;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributeclient.BlueGigaPrepareWriteResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributeclient.BlueGigaProcedureCompletedEvent;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributeclient.BlueGigaReadByGroupTypeResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributeclient.BlueGigaReadByHandleResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributeclient.BlueGigaReadByTypeResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributeclient.BlueGigaReadLongResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributeclient.BlueGigaReadMultipleResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributeclient.BlueGigaReadMultipleResponseEvent;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributeclient.BlueGigaWriteCommandResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributedb.BlueGigaAttributeStatusEvent;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributedb.BlueGigaReadResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributedb.BlueGigaReadTypeResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributedb.BlueGigaSendAttributesResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributedb.BlueGigaUserReadRequestEvent;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributedb.BlueGigaUserReadResponseResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributedb.BlueGigaUserWriteResponseResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributedb.BlueGigaValueEvent;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributedb.BlueGigaWriteResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.connection.BlueGigaChannelMapGetResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.connection.BlueGigaConnectionStatusEvent;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.connection.BlueGigaDisconnectResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.connection.BlueGigaDisconnectedEvent;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.connection.BlueGigaFeatureIndEvent;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.connection.BlueGigaGetRssiResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.connection.BlueGigaGetStatusResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.connection.BlueGigaUpdateResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.connection.BlueGigaVersionIndEvent;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.gap.BlueGigaConnectDirectResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.gap.BlueGigaConnectSelectiveResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.gap.BlueGigaDiscoverResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.gap.BlueGigaEndProcedureResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.gap.BlueGigaScanResponseEvent;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.gap.BlueGigaSetAdvDataResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.gap.BlueGigaSetAdvParametersResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.gap.BlueGigaSetModeResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.gap.BlueGigaSetScanParametersResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.security.BlueGigaBondStatusEvent;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.security.BlueGigaBondingFailEvent;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.security.BlueGigaDeleteBondingResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.security.BlueGigaEncryptStartResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.security.BlueGigaGetBondsResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.security.BlueGigaPassKeyResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.security.BlueGigaPasskeyDisplayEvent;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.security.BlueGigaPasskeyRequestEvent;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.security.BlueGigaSetBondableModeResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.security.BlueGigaSetParametersResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.security.BlueGigaWhitelistBondsResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.system.BlueGigaAddressGetResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.system.BlueGigaBootEvent;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.system.BlueGigaEndpointWatermarkRxEvent;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.system.BlueGigaEndpointWatermarkTxEvent;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.system.BlueGigaGetConnectionsResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.system.BlueGigaGetCountersResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.system.BlueGigaGetInfoResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.system.BlueGigaHelloResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.system.BlueGigaNoLicenseKeyEvent;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.system.BlueGigaProtocolErrorEvent;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.system.BlueGigaResetResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.system.BlueGigaWhitelistAppendResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.system.BlueGigaWhitelistClearResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.system.BlueGigaWhitelistRemoveResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BlueGigaResponsePackets {
    private static Logger logger = LoggerFactory.getLogger(BlueGigaResponsePackets.class);
    private static final Map<Integer, Class<?>> packetMap = new HashMap();

    static {
        packetMap.put(Objects.hash(0, 6, true), BlueGigaProtocolErrorEvent.class);
        packetMap.put(Objects.hash(0, 2, true), BlueGigaEndpointWatermarkRxEvent.class);
        packetMap.put(Objects.hash(0, 3, true), BlueGigaEndpointWatermarkTxEvent.class);
        packetMap.put(Objects.hash(0, 5, true), BlueGigaNoLicenseKeyEvent.class);
        packetMap.put(Objects.hash(4, 5, false), BlueGigaAttributeWriteResponse.class);
        packetMap.put(Objects.hash(4, 10, false), BlueGigaExecuteWriteResponse.class);
        packetMap.put(Objects.hash(4, 0, false), BlueGigaFindByTypeValueResponse.class);
        packetMap.put(Objects.hash(4, 3, false), BlueGigaFindInformationResponse.class);
        packetMap.put(Objects.hash(4, 7, false), BlueGigaIndicateConfirmResponse.class);
        packetMap.put(Objects.hash(4, 9, false), BlueGigaPrepareWriteResponse.class);
        packetMap.put(Objects.hash(4, 1, false), BlueGigaReadByGroupTypeResponse.class);
        packetMap.put(Objects.hash(4, 4, false), BlueGigaReadByHandleResponse.class);
        packetMap.put(Objects.hash(4, 2, false), BlueGigaReadByTypeResponse.class);
        packetMap.put(Objects.hash(4, 8, false), BlueGigaReadLongResponse.class);
        packetMap.put(Objects.hash(4, 11, false), BlueGigaReadMultipleResponse.class);
        packetMap.put(Objects.hash(4, 6, false), BlueGigaWriteCommandResponse.class);
        packetMap.put(Objects.hash(4, 1, true), BlueGigaProcedureCompletedEvent.class);
        packetMap.put(Objects.hash(4, 5, true), BlueGigaAttributeValueEvent.class);
        packetMap.put(Objects.hash(4, 4, true), BlueGigaFindInformationFoundEvent.class);
        packetMap.put(Objects.hash(4, 2, true), BlueGigaGroupFoundEvent.class);
        packetMap.put(Objects.hash(4, 0, true), BlueGigaIndicatedEvent.class);
        packetMap.put(Objects.hash(4, 0, true), BlueGigaReadMultipleResponseEvent.class);
        packetMap.put(Objects.hash(2, 1, false), BlueGigaReadResponse.class);
        packetMap.put(Objects.hash(2, 2, false), BlueGigaReadTypeResponse.class);
        packetMap.put(Objects.hash(2, 2, false), BlueGigaSendAttributesResponse.class);
        packetMap.put(Objects.hash(2, 3, false), BlueGigaUserReadResponseResponse.class);
        packetMap.put(Objects.hash(2, 4, false), BlueGigaUserWriteResponseResponse.class);
        packetMap.put(Objects.hash(2, 0, false), BlueGigaWriteResponse.class);
        packetMap.put(Objects.hash(2, 2, true), BlueGigaAttributeStatusEvent.class);
        packetMap.put(Objects.hash(2, 1, true), BlueGigaUserReadRequestEvent.class);
        packetMap.put(Objects.hash(2, 0, true), BlueGigaValueEvent.class);
        packetMap.put(Objects.hash(3, 4, false), BlueGigaChannelMapGetResponse.class);
        packetMap.put(Objects.hash(3, 0, false), BlueGigaDisconnectResponse.class);
        packetMap.put(Objects.hash(3, 1, false), BlueGigaGetRssiResponse.class);
        packetMap.put(Objects.hash(3, 7, false), BlueGigaGetStatusResponse.class);
        packetMap.put(Objects.hash(3, 2, false), BlueGigaUpdateResponse.class);
        packetMap.put(Objects.hash(3, 4, true), BlueGigaDisconnectedEvent.class);
        packetMap.put(Objects.hash(3, 2, true), BlueGigaFeatureIndEvent.class);
        packetMap.put(Objects.hash(3, 0, true), BlueGigaConnectionStatusEvent.class);
        packetMap.put(Objects.hash(3, 1, true), BlueGigaVersionIndEvent.class);
        packetMap.put(Objects.hash(6, 7, false), BlueGigaSetScanParametersResponse.class);
        packetMap.put(Objects.hash(6, 3, false), BlueGigaConnectDirectResponse.class);
        packetMap.put(Objects.hash(6, 5, false), BlueGigaConnectSelectiveResponse.class);
        packetMap.put(Objects.hash(6, 2, false), BlueGigaDiscoverResponse.class);
        packetMap.put(Objects.hash(6, 8, false), BlueGigaSetAdvParametersResponse.class);
        packetMap.put(Objects.hash(6, 9, false), BlueGigaSetAdvDataResponse.class);
        packetMap.put(Objects.hash(6, 4, false), BlueGigaEndProcedureResponse.class);
        packetMap.put(Objects.hash(6, 1, false), BlueGigaSetModeResponse.class);
        packetMap.put(Objects.hash(6, 0, true), BlueGigaScanResponseEvent.class);
        packetMap.put(Objects.hash(5, 2, false), BlueGigaDeleteBondingResponse.class);
        packetMap.put(Objects.hash(5, 0, false), BlueGigaEncryptStartResponse.class);
        packetMap.put(Objects.hash(5, 5, false), BlueGigaGetBondsResponse.class);
        packetMap.put(Objects.hash(5, 4, false), BlueGigaPassKeyResponse.class);
        packetMap.put(Objects.hash(5, 1, false), BlueGigaSetBondableModeResponse.class);
        packetMap.put(Objects.hash(5, 3, false), BlueGigaSetParametersResponse.class);
        packetMap.put(Objects.hash(5, 7, false), BlueGigaWhitelistBondsResponse.class);
        packetMap.put(Objects.hash(0, 10, false), BlueGigaWhitelistAppendResponse.class);
        packetMap.put(Objects.hash(0, 11, false), BlueGigaWhitelistRemoveResponse.class);
        packetMap.put(Objects.hash(0, 12, false), BlueGigaWhitelistClearResponse.class);
        packetMap.put(Objects.hash(5, 1, true), BlueGigaBondingFailEvent.class);
        packetMap.put(Objects.hash(5, 4, true), BlueGigaBondStatusEvent.class);
        packetMap.put(Objects.hash(5, 2, true), BlueGigaPasskeyDisplayEvent.class);
        packetMap.put(Objects.hash(5, 3, true), BlueGigaPasskeyRequestEvent.class);
        packetMap.put(Objects.hash(0, 2, false), BlueGigaAddressGetResponse.class);
        packetMap.put(Objects.hash(0, 1, false), BlueGigaHelloResponse.class);
        packetMap.put(Objects.hash(0, 0, false), BlueGigaResetResponse.class);
        packetMap.put(Objects.hash(0, 6, false), BlueGigaGetConnectionsResponse.class);
        packetMap.put(Objects.hash(0, 5, false), BlueGigaGetCountersResponse.class);
        packetMap.put(Objects.hash(0, 8, false), BlueGigaGetInfoResponse.class);
        packetMap.put(Objects.hash(0, 0, true), BlueGigaBootEvent.class);
    }

    BlueGigaResponsePackets() {
    }

    public static BlueGigaResponse getPacket(int[] data) {
        int cmdClass = data[2];
        int cmdMethod = data[3];
        boolean isEvent = (data[0] & 0x80) != 0;
        Class<?> bleClass = packetMap.get(Objects.hash(cmdClass, cmdMethod, isEvent));
        if (bleClass == null) {
            return null;
        }
        try {
            Constructor<?> ctor = bleClass.getConstructor(int[].class);
            BlueGigaResponse bleFrame = (BlueGigaResponse)ctor.newInstance(new Object[]{data});
            return bleFrame;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            logger.error("Error instantiating BLE class", (Throwable)e);
            return null;
        }
    }
}

