/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.attributeclient;

import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.BlueGigaCommand;

public class BlueGigaPrepareWriteCommand
extends BlueGigaCommand {
    public static int COMMAND_CLASS = 4;
    public static int COMMAND_METHOD = 9;
    private int connection;
    private int attHandle;
    private int offset;
    private int[] data;

    public void setConnection(int connection) {
        this.connection = connection;
    }

    public void setAttHandle(int attHandle) {
        this.attHandle = attHandle;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setData(int[] data) {
        this.data = data;
    }

    @Override
    public int[] serialize() {
        this.serializeHeader(COMMAND_CLASS, COMMAND_METHOD);
        this.serializeUInt8(this.connection);
        this.serializeUInt16(this.attHandle);
        this.serializeUInt16(this.offset);
        this.serializeUInt8Array(this.data);
        return this.getPayload();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BlueGigaPrepareWriteCommand [connection=");
        builder.append(this.connection);
        builder.append(", attHandle=");
        builder.append(this.attHandle);
        builder.append(", offset=");
        builder.append(this.offset);
        builder.append(", data=");
        int c = 0;
        while (c < this.data.length) {
            if (c > 0) {
                builder.append(' ');
            }
            builder.append(String.format("%02X", this.data[c]));
            ++c;
        }
        builder.append(']');
        return builder.toString();
    }
}

