/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.connection;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.BlueGigaResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.enumeration.BluetoothAddressType;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.enumeration.ConnectionStatusFlag;

public class BlueGigaConnectionStatusEvent
extends BlueGigaResponse {
    public static int COMMAND_CLASS = 3;
    public static int COMMAND_METHOD = 0;
    private int connection;
    private Set<ConnectionStatusFlag> flags = new HashSet<ConnectionStatusFlag>();
    private String address;
    private BluetoothAddressType addressType;
    private int connInterval;
    private int timeout;
    private int latency;
    private int bonding;

    public BlueGigaConnectionStatusEvent(int[] inputBuffer) {
        super(inputBuffer);
        this.event = (inputBuffer[0] & 0x80) != 0;
        this.connection = this.deserializeUInt8();
        this.flags = this.deserializeConnectionStatusFlag();
        this.address = this.deserializeAddress();
        this.addressType = this.deserializeBluetoothAddressType();
        this.connInterval = this.deserializeUInt16();
        this.timeout = this.deserializeUInt16();
        this.latency = this.deserializeUInt16();
        this.bonding = this.deserializeUInt8();
    }

    public int getConnection() {
        return this.connection;
    }

    public Set<ConnectionStatusFlag> getFlags() {
        return this.flags;
    }

    public String getAddress() {
        return this.address;
    }

    public BluetoothAddressType getAddressType() {
        return this.addressType;
    }

    public int getConnInterval() {
        return this.connInterval;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getLatency() {
        return this.latency;
    }

    public int getBonding() {
        return this.bonding;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BlueGigaConnectionStatusEvent [connection=");
        builder.append(this.connection);
        builder.append(", flags=");
        builder.append(this.flags);
        builder.append(", address=");
        builder.append(this.address);
        builder.append(", addressType=");
        builder.append((Object)this.addressType);
        builder.append(", connInterval=");
        builder.append(this.connInterval);
        builder.append(", timeout=");
        builder.append(this.timeout);
        builder.append(", latency=");
        builder.append(this.latency);
        builder.append(", bonding=");
        builder.append(this.bonding);
        builder.append(']');
        return builder.toString();
    }
}

