/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.command.gap;

import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.BlueGigaResponse;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.enumeration.BluetoothAddressType;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.enumeration.ScanResponseType;

public class BlueGigaScanResponseEvent
extends BlueGigaResponse {
    public static int COMMAND_CLASS = 6;
    public static int COMMAND_METHOD = 0;
    private int rssi;
    private ScanResponseType packetType;
    private String sender;
    private BluetoothAddressType addressType;
    private int bond;
    private int[] data;

    public BlueGigaScanResponseEvent(int[] inputBuffer) {
        super(inputBuffer);
        this.event = (inputBuffer[0] & 0x80) != 0;
        this.rssi = this.deserializeInt8();
        this.packetType = this.deserializeScanResponseType();
        this.sender = this.deserializeAddress();
        this.addressType = this.deserializeBluetoothAddressType();
        this.bond = this.deserializeUInt8();
        this.data = this.deserializeUInt8Array();
    }

    public int getRssi() {
        return this.rssi;
    }

    public ScanResponseType getPacketType() {
        return this.packetType;
    }

    public String getSender() {
        return this.sender;
    }

    public BluetoothAddressType getAddressType() {
        return this.addressType;
    }

    public int getBond() {
        return this.bond;
    }

    public int[] getData() {
        return this.data;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BlueGigaScanResponseEvent [rssi=");
        builder.append(this.rssi);
        builder.append(", packetType=");
        builder.append((Object)this.packetType);
        builder.append(", sender=");
        builder.append(this.sender);
        builder.append(", addressType=");
        builder.append((Object)this.addressType);
        builder.append(", bond=");
        builder.append(this.bond);
        builder.append(", data=");
        int c = 0;
        while (c < this.data.length) {
            if (c > 0) {
                builder.append(' ');
            }
            builder.append(String.format("%02X", this.data[c]));
            ++c;
        }
        builder.append(']');
        return builder.toString();
    }
}

