/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.eir;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.eir.EirDataType;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.eir.EirRecord;

public class EirPacket {
    private Map<EirDataType, Object> records = new HashMap<EirDataType, Object>();

    public EirPacket(int[] data) {
        if (data == null || data.length == 0) {
            return;
        }
        int cnt = 0;
        while (cnt < data.length) {
            if (data[cnt] == 0) break;
            int[] rawRecord = Arrays.copyOfRange(data, cnt + 1, cnt + data[cnt] + 1);
            EirRecord record = new EirRecord(rawRecord);
            cnt += data[cnt] + 1;
            this.records.put(record.getType(), record.getRecord());
        }
    }

    public Map<EirDataType, Object> getRecords() {
        return this.records;
    }

    public Object getRecord(EirDataType recordType) {
        return this.records.get((Object)recordType);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("EirPacket [records=");
        builder.append(this.records);
        builder.append(']');
        return builder.toString();
    }
}

