/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.eir;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.eir.EirDataType;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.eir.EirFlags;

public class EirRecord {
    private EirDataType type;
    private Object record;

    EirRecord(int[] data) {
        if (data == null || data.length == 0) {
            return;
        }
        this.type = EirDataType.getEirPacketType(data[0]);
        switch (this.type) {
            case EIR_FLAGS: {
                this.record = this.processFlags(data);
                break;
            }
            case EIR_MANUFACTURER_SPECIFIC: {
                this.record = this.processManufacturer(data);
                break;
            }
            case EIR_SVC_UUID16_INCOMPLETE: 
            case EIR_SVC_UUID16_COMPLETE: {
                this.record = this.processUuid16(data);
                break;
            }
            case EIR_SVC_UUID32_INCOMPLETE: 
            case EIR_SVC_UUID32_COMPLETE: {
                this.record = this.processUuid32(data);
                break;
            }
            case EIR_SVC_UUID128_INCOMPLETE: 
            case EIR_SVC_UUID128_COMPLETE: {
                this.record = this.processUuid128(data);
                break;
            }
            case EIR_NAME_SHORT: 
            case EIR_NAME_LONG: {
                this.record = this.processString(data);
                break;
            }
            case EIR_TXPOWER: {
                this.record = this.processUInt8(data);
                break;
            }
            case EIR_SLAVEINTERVALRANGE: {
                this.record = this.processUInt16List(data);
                break;
            }
            case EIR_DEVICE_CLASS: {
                this.record = this.processUInt8(data);
                break;
            }
            case EIR_SVC_DATA_UUID16: {
                this.record = this.processUUID16ServiceData(data);
                break;
            }
            case EIR_SVC_DATA_UUID32: {
                this.record = this.processUUID32ServiceData(data);
                break;
            }
            case EIR_SVC_DATA_UUID128: {
                this.record = this.processUUID128ServiceData(data);
                break;
            }
            default: {
                this.record = this.processUnknown(data);
            }
        }
    }

    private Map<Short, int[]> processManufacturer(int[] data) {
        short manufacturer = (short)((data[2] & 0xFFFF) << 8 | data[1] & 0xFFFF);
        return Collections.singletonMap(manufacturer, Arrays.copyOfRange(data, 3, data.length));
    }

    private Map<UUID, int[]> processUUID16ServiceData(int[] data) {
        return Collections.singletonMap(this.process16BitUUID(data, 1), Arrays.copyOfRange(data, 3, data.length));
    }

    private Map<UUID, int[]> processUUID32ServiceData(int[] data) {
        return Collections.singletonMap(this.process32BitUUID(data, 1), Arrays.copyOfRange(data, 5, data.length));
    }

    private Map<UUID, int[]> processUUID128ServiceData(int[] data) {
        return Collections.singletonMap(this.process128BitUUID(data, 1), Arrays.copyOfRange(data, 17, data.length));
    }

    private List<UUID> processUuid16(int[] data) {
        ArrayList<UUID> uuidList = new ArrayList<UUID>();
        int cnt = 1;
        while (cnt < data.length - 1) {
            uuidList.add(this.process16BitUUID(data, cnt));
            cnt += 2;
        }
        return uuidList;
    }

    private List<UUID> processUuid32(int[] data) {
        ArrayList<UUID> uuidList = new ArrayList<UUID>();
        int cnt = 1;
        while (cnt < data.length - 1) {
            uuidList.add(this.process32BitUUID(data, cnt));
            cnt += 4;
        }
        return uuidList;
    }

    private List<UUID> processUuid128(int[] data) {
        ArrayList<UUID> uuidList = new ArrayList<UUID>();
        int cnt = 1;
        while (cnt < data.length - 1) {
            uuidList.add(this.process128BitUUID(data, cnt));
            cnt += 16;
        }
        return uuidList;
    }

    private UUID process16BitUUID(int[] data, int index) {
        long high = ((long)data[index] << 32) + ((long)data[index + 1] << 40);
        return new UUID(high, 0L);
    }

    private UUID process32BitUUID(int[] data, int index) {
        long high = ((long)data[index] << 32) + ((long)data[index + 1] << 40) + ((long)data[index + 2] << 48) + ((long)data[index + 3] << 56);
        return new UUID(high, 0L);
    }

    private UUID process128BitUUID(int[] data, int index) {
        long low = (long)data[index] + ((long)data[index + 1] << 8) + ((long)data[index + 2] << 16) + ((long)data[index + 3] << 24) + ((long)data[index + 4] << 32) + ((long)data[index + 5] << 40) + ((long)data[index + 6] << 48) + ((long)data[index + 7] << 56);
        long high = (long)data[index + 8] + ((long)data[index + 9] << 8) + ((long)data[index + 10] << 16) + ((long)data[index + 11] << 24) + ((long)data[index + 12] << 32) + ((long)data[index + 13] << 40) + ((long)data[index + 14] << 48) + ((long)data[index + 15] << 56);
        return new UUID(high, low);
    }

    private List<Integer> processUInt16List(int[] data) {
        ArrayList<Integer> intList = new ArrayList<Integer>();
        int cnt = 1;
        while (cnt < data.length - 1) {
            intList.add(data[cnt] + (data[cnt + 1] << 8));
            cnt += 2;
        }
        return intList;
    }

    private List<EirFlags> processFlags(int[] data) {
        ArrayList<EirFlags> flags = new ArrayList<EirFlags>();
        int flagBit = 0;
        int cnt = 1;
        while (cnt < data.length) {
            int bitcnt = 0;
            while (bitcnt < 8) {
                if ((data[cnt] & 1 << bitcnt) != 0) {
                    flags.add(EirFlags.getEirFlag(flagBit));
                }
                ++flagBit;
                ++bitcnt;
            }
            ++cnt;
        }
        return flags;
    }

    private String processString(int[] data) {
        StringBuilder builder = new StringBuilder();
        int cnt = 1;
        while (cnt < data.length) {
            builder.append((char)data[cnt]);
            ++cnt;
        }
        return builder.toString();
    }

    private int processUInt8(int[] data) {
        if (data[1] > 127) {
            return data[1] - 256;
        }
        return data[1];
    }

    private String processUnknown(int[] data) {
        StringBuilder builder = new StringBuilder();
        int cnt = 0;
        while (cnt < data.length) {
            builder.append(String.format("%02X", data[cnt]));
            ++cnt;
        }
        return builder.toString();
    }

    public EirDataType getType() {
        return this.type;
    }

    public Object getRecord() {
        return this.record;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("EirRecord [type=");
        builder.append((Object)this.type);
        builder.append(", record=");
        builder.append(this.record);
        builder.append(']');
        return builder.toString();
    }
}

