/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.enumeration;

import java.util.HashMap;
import java.util.Map;

public enum BluetoothAddressType {
    UNKNOWN(-1),
    GAP_ADDRESS_TYPE_PUBLIC(0),
    GAP_ADDRESS_TYPE_RANDOM(1);

    private static Map<Integer, BluetoothAddressType> codeMapping;
    private int key;

    private BluetoothAddressType(int key) {
        this.key = key;
    }

    private static void initMapping() {
        codeMapping = new HashMap<Integer, BluetoothAddressType>();
        BluetoothAddressType[] bluetoothAddressTypeArray = BluetoothAddressType.values();
        int n = bluetoothAddressTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            BluetoothAddressType s = bluetoothAddressTypeArray[n2];
            codeMapping.put(s.key, s);
            ++n2;
        }
    }

    public static BluetoothAddressType getBluetoothAddressType(int bluetoothAddressType) {
        if (codeMapping == null) {
            BluetoothAddressType.initMapping();
        }
        if (codeMapping.get(bluetoothAddressType) == null) {
            return UNKNOWN;
        }
        return codeMapping.get(bluetoothAddressType);
    }

    public int getKey() {
        return this.key;
    }
}

