/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.enumeration;

import java.util.HashMap;
import java.util.Map;

public enum GapDiscoverMode {
    UNKNOWN(-1),
    GAP_DISCOVER_LIMITED(0),
    GAP_DISCOVER_GENERIC(1),
    GAP_DISCOVER_OBSERVATION(2),
    GAP_BROADCAST(3),
    GAP_USER_DATA(4),
    GAP_ENHANCED_BROADCASTING(128);

    private static Map<Integer, GapDiscoverMode> codeMapping;
    private int key;

    private GapDiscoverMode(int key) {
        this.key = key;
    }

    private static void initMapping() {
        codeMapping = new HashMap<Integer, GapDiscoverMode>();
        GapDiscoverMode[] gapDiscoverModeArray = GapDiscoverMode.values();
        int n = gapDiscoverModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            GapDiscoverMode s = gapDiscoverModeArray[n2];
            codeMapping.put(s.key, s);
            ++n2;
        }
    }

    public static GapDiscoverMode getGapDiscoverMode(int gapDiscoverMode) {
        if (codeMapping == null) {
            GapDiscoverMode.initMapping();
        }
        if (codeMapping.get(gapDiscoverMode) == null) {
            return UNKNOWN;
        }
        return codeMapping.get(gapDiscoverMode);
    }

    public int getKey() {
        return this.key;
    }
}

