/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bluetooth.bluegiga.internal.factory;

import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.eclipse.smarthome.binding.bluetooth.BluetoothAdapter;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.BlueGigaAdapterConstants;
import org.eclipse.smarthome.binding.bluetooth.bluegiga.handler.BlueGigaBridgeHandler;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.UID;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandlerFactory;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerFactory;
import org.eclipse.smarthome.io.transport.serial.SerialPortManager;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@Component(service={ThingHandlerFactory.class}, immediate=true, configurationPid="binding.bluegiga", configurationPolicy=ConfigurationPolicy.OPTIONAL)
public class BlueGigaHandlerFactory
extends BaseThingHandlerFactory {
    private static final Set<ThingTypeUID> SUPPORTED_THING_TYPES_UIDS = Collections.singleton(BlueGigaAdapterConstants.THING_TYPE_BLUEGIGA);
    private final Map<ThingUID, ServiceRegistration<?>> serviceRegs = new HashMap();
    private SerialPortManager serialPortManager;

    @Reference
    protected void setSerialPortManager(SerialPortManager serialPortManager) {
        this.serialPortManager = serialPortManager;
    }

    protected void unsetSerialPortManager(SerialPortManager serialPortManager) {
        this.serialPortManager = null;
    }

    public boolean supportsThingType(ThingTypeUID thingTypeUID) {
        return SUPPORTED_THING_TYPES_UIDS.contains(thingTypeUID);
    }

    protected ThingHandler createHandler(Thing thing) {
        ThingTypeUID thingTypeUID = thing.getThingTypeUID();
        if (thingTypeUID.equals((Object)BlueGigaAdapterConstants.THING_TYPE_BLUEGIGA)) {
            BlueGigaBridgeHandler handler = new BlueGigaBridgeHandler((Bridge)thing, this.serialPortManager);
            this.registerBluetoothAdapter(handler);
            return handler;
        }
        return null;
    }

    private synchronized void registerBluetoothAdapter(BluetoothAdapter adapter) {
        this.serviceRegs.put((ThingUID)adapter.getUID(), this.bundleContext.registerService(BluetoothAdapter.class.getName(), (Object)adapter, new Hashtable()));
    }

    protected synchronized void removeHandler(ThingHandler thingHandler) {
        UID uid;
        ServiceRegistration<?> serviceReg;
        if (thingHandler instanceof BluetoothAdapter && (serviceReg = this.serviceRegs.remove(uid = (UID)((BluetoothAdapter)thingHandler).getUID())) != null) {
            serviceReg.unregister();
        }
    }
}

