/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bluetooth.bluez.handler;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.bluetooth.BluetoothAdapter;
import org.eclipse.smarthome.binding.bluetooth.BluetoothAddress;
import org.eclipse.smarthome.binding.bluetooth.BluetoothDevice;
import org.eclipse.smarthome.binding.bluetooth.BluetoothDiscoveryListener;
import org.eclipse.smarthome.binding.bluetooth.bluez.BlueZBluetoothDevice;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.BaseBridgeHandler;
import org.eclipse.smarthome.core.types.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tinyb.BluetoothManager;

public class BlueZBridgeHandler
extends BaseBridgeHandler
implements BluetoothAdapter {
    private final Logger logger = LoggerFactory.getLogger(BlueZBridgeHandler.class);
    private tinyb.BluetoothAdapter adapter;
    private final Map<String, tinyb.BluetoothDevice> tinybDeviceCache = new ConcurrentHashMap<String, tinyb.BluetoothDevice>();
    private BluetoothAddress address;
    private boolean discoveryActive = true;
    private final Map<String, BluetoothDevice> devices = new ConcurrentHashMap<String, BluetoothDevice>();
    protected final Set<BluetoothDiscoveryListener> discoveryListeners = new CopyOnWriteArraySet<BluetoothDiscoveryListener>();
    private ScheduledFuture<?> discoveryJob;

    public BlueZBridgeHandler(Bridge bridge) {
        super(bridge);
    }

    public void initialize() {
        try {
            BluetoothManager.getBluetoothManager();
        }
        catch (UnsatisfiedLinkError e) {
            throw new IllegalStateException("BlueZ JNI connection cannot be established.", e);
        }
        catch (RuntimeException e) {
            if (e.getMessage().contains("AccessDenied")) {
                throw new IllegalStateException("Cannot access BlueZ stack due to permission problems. Make sure that your OS user is part of the 'bluetooth' group of BlueZ.");
            }
            throw new IllegalStateException("Cannot access BlueZ layer.", e);
        }
        Object cfgAddress = this.getConfig().get("address");
        if (cfgAddress == null) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "address not set");
            return;
        }
        this.address = new BluetoothAddress(cfgAddress.toString());
        Object discovery = this.getConfig().get("discovery");
        if (discovery != null && discovery.toString().equalsIgnoreCase(Boolean.FALSE.toString())) {
            this.discoveryActive = false;
            this.logger.debug("Deactivated discovery participation.");
        }
        this.logger.debug("Creating BlueZ adapter with address '{}'", (Object)this.address);
        for (tinyb.BluetoothAdapter a : BluetoothManager.getBluetoothManager().getAdapters()) {
            if (!a.getAddress().equals(this.address.toString())) continue;
            this.adapter = a;
            this.updateStatus(ThingStatus.ONLINE);
            if (!this.adapter.getDiscovering()) {
                this.adapter.startDiscovery();
            }
            this.discoveryJob = this.scheduler.scheduleWithFixedDelay(() -> this.checkForNewDevices(), 0L, 10L, TimeUnit.SECONDS);
            return;
        }
        this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "No adapter for this address found.");
    }

    public ThingUID getUID() {
        return this.getThing().getUID();
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
    }

    public void addDiscoveryListener(BluetoothDiscoveryListener listener) {
        this.discoveryListeners.add(listener);
    }

    public void removeDiscoveryListener(@Nullable BluetoothDiscoveryListener listener) {
        this.discoveryListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanStart() {
        if (this.adapter != null) {
            if (!this.adapter.getDiscovering()) {
                this.adapter.setRssiDiscoveryFilter(-96);
                this.adapter.startDiscovery();
            }
            for (tinyb.BluetoothDevice tinybDevice : this.adapter.getDevices()) {
                Map<String, BluetoothDevice> map = this.devices;
                synchronized (map) {
                    this.logger.debug("Device {} has RSSI {}", (Object)tinybDevice.getAddress(), (Object)tinybDevice.getRSSI());
                    BluetoothDevice device = this.devices.get(tinybDevice.getAddress());
                    if (device == null) {
                        this.createAndRegisterBlueZDevice(tinybDevice);
                    } else {
                        device.setRssi((int)tinybDevice.getRSSI());
                        device.setTxPower((int)tinybDevice.getTxPower());
                        this.notifyDiscoveryListeners(device);
                    }
                }
            }
        }
    }

    public void scanStop() {
    }

    public BluetoothAddress getAddress() {
        return this.address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BluetoothDevice getDevice(BluetoothAddress address) {
        if (this.devices.containsKey(address.toString())) {
            return this.devices.get(address.toString());
        }
        Map<String, BluetoothDevice> map = this.devices;
        synchronized (map) {
            if (this.devices.containsKey(address.toString())) {
                return this.devices.get(address.toString());
            }
            BlueZBluetoothDevice device = new BlueZBluetoothDevice(this, address, "");
            device.initialize();
            this.devices.put(address.toString(), device);
            return device;
        }
    }

    public void dispose() {
        if (this.discoveryJob != null) {
            this.discoveryJob.cancel(true);
            this.discoveryJob = null;
        }
        for (BluetoothDevice device : this.devices.values()) {
            ((BlueZBluetoothDevice)device).dispose();
        }
        this.devices.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<tinyb.BluetoothDevice> getTinyBDevices() {
        Map<String, tinyb.BluetoothDevice> map = this.tinybDeviceCache;
        synchronized (map) {
            return Collections.unmodifiableCollection(this.tinybDeviceCache.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForNewDevices() {
        this.logger.debug("Refreshing Bluetooth device list...");
        HashSet<String> newAddresses = new HashSet<String>();
        List tinybDevices = this.adapter.getDevices();
        this.logger.debug("Found {} Bluetooth devices.", (Object)tinybDevices.size());
        Map<String, tinyb.BluetoothDevice> map = this.tinybDeviceCache;
        synchronized (map) {
            this.tinybDeviceCache.clear();
            tinybDevices.stream().forEach(d -> {
                tinyb.BluetoothDevice bluetoothDevice = this.tinybDeviceCache.put(d.getAddress(), (tinyb.BluetoothDevice)d);
            });
        }
        for (tinyb.BluetoothDevice tinybDevice : tinybDevices) {
            Map<String, BluetoothDevice> map2 = this.devices;
            synchronized (map2) {
                newAddresses.add(tinybDevice.getAddress());
                BlueZBluetoothDevice device = (BlueZBluetoothDevice)this.devices.get(tinybDevice.getAddress());
                if (device == null) {
                    this.createAndRegisterBlueZDevice(tinybDevice);
                } else {
                    device.updateTinybDevice(tinybDevice);
                    this.notifyDiscoveryListeners(device);
                }
            }
        }
        map = this.devices;
        synchronized (map) {
            Set<String> oldAdresses = this.devices.keySet();
            for (String address : oldAdresses) {
                if (newAddresses.contains(address)) continue;
                this.devices.remove(address);
            }
        }
    }

    private BlueZBluetoothDevice createAndRegisterBlueZDevice(tinyb.BluetoothDevice tinybDevice) {
        BlueZBluetoothDevice device = new BlueZBluetoothDevice(this, tinybDevice);
        device.initialize();
        this.devices.put(tinybDevice.getAddress(), device);
        this.notifyDiscoveryListeners(device);
        return device;
    }

    private void notifyDiscoveryListeners(BluetoothDevice device) {
        if (this.discoveryActive && this.deviceReachable(device)) {
            for (BluetoothDiscoveryListener listener : this.discoveryListeners) {
                listener.deviceDiscovered(device);
            }
        } else {
            this.logger.trace("Not notifying listeners for device '{}', because it is not reachable.", (Object)device.getAddress());
        }
    }

    private boolean deviceReachable(BluetoothDevice device) {
        Integer rssi = device.getRssi();
        return rssi != null && rssi != 0;
    }
}

