/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bluetooth.blukii.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.bluetooth.BluetoothDevice;
import org.eclipse.smarthome.binding.bluetooth.blukii.BlukiiBindingConstants;
import org.eclipse.smarthome.binding.bluetooth.discovery.BluetoothDiscoveryParticipant;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryResultBuilder;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true)
public class BlukiiDiscoveryParticipant
implements BluetoothDiscoveryParticipant {
    public @NonNull Set<@NonNull ThingTypeUID> getSupportedThingTypeUIDs() {
        return Collections.singleton(BlukiiBindingConstants.THING_TYPE_BEACON);
    }

    public @Nullable ThingUID getThingUID(@NonNull BluetoothDevice device) {
        String name = device.getName();
        if (name != null && name.startsWith("blukii ") && name.charAt("blukii ".length()) == 'B') {
            return new ThingUID(BlukiiBindingConstants.THING_TYPE_BEACON, (ThingUID)device.getAdapter().getUID(), device.getAddress().toString().toLowerCase().replace(":", ""));
        }
        return null;
    }

    public DiscoveryResult createResult(@NonNull BluetoothDevice device) {
        ThingUID thingUID = this.getThingUID(device);
        if (thingUID != null) {
            String label = "Blukii SmartBeacon";
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("address", device.getAddress().toString());
            properties.put("vendor", "Schneider Schreibger\u00e4te GmbH");
            Integer txPower = device.getTxPower();
            if (txPower != null) {
                properties.put("txpower", Integer.toString(txPower));
            }
            return DiscoveryResultBuilder.create((ThingUID)thingUID).withProperties(properties).withRepresentationProperty("address").withBridge((ThingUID)device.getAdapter().getUID()).withLabel(label).build();
        }
        return null;
    }
}

