/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bluetooth.internal;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.smarthome.binding.bluetooth.BeaconBluetoothHandler;
import org.eclipse.smarthome.binding.bluetooth.BluetoothBindingConstants;
import org.eclipse.smarthome.binding.bluetooth.ConnectedBluetoothHandler;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandlerFactory;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerFactory;
import org.osgi.service.component.annotations.Component;

@Component(service={ThingHandlerFactory.class}, configurationPid="binding.bluetooth")
public class BluetoothHandlerFactory
extends BaseThingHandlerFactory {
    private static final Set<ThingTypeUID> SUPPORTED_THING_TYPES_UIDS = new HashSet<ThingTypeUID>();

    static {
        SUPPORTED_THING_TYPES_UIDS.add(BluetoothBindingConstants.THING_TYPE_BEACON);
        SUPPORTED_THING_TYPES_UIDS.add(BluetoothBindingConstants.THING_TYPE_CONNECTED);
    }

    public boolean supportsThingType(ThingTypeUID thingTypeUID) {
        return SUPPORTED_THING_TYPES_UIDS.contains(thingTypeUID);
    }

    protected ThingHandler createHandler(Thing thing) {
        ThingTypeUID thingTypeUID = thing.getThingTypeUID();
        if (thingTypeUID.equals((Object)BluetoothBindingConstants.THING_TYPE_BEACON)) {
            return new BeaconBluetoothHandler(thing);
        }
        if (thingTypeUID.equals((Object)BluetoothBindingConstants.THING_TYPE_CONNECTED)) {
            return new ConnectedBluetoothHandler(thing);
        }
        return null;
    }
}

