/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bosesoundtouch.internal;

import org.eclipse.smarthome.binding.bosesoundtouch.BoseSoundTouchBindingConstants;
import org.eclipse.smarthome.binding.bosesoundtouch.handler.BoseSoundTouchHandler;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.BoseStateDescriptionOptionProvider;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.ContentItem;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.PresetContainer;
import org.eclipse.smarthome.core.storage.Storage;
import org.eclipse.smarthome.core.storage.StorageService;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandlerFactory;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ThingHandlerFactory.class}, immediate=true, configurationPid={"binding.bosesoundtouch"})
public class BoseSoundTouchHandlerFactory
extends BaseThingHandlerFactory {
    private StorageService storageService;
    private BoseStateDescriptionOptionProvider stateOptionProvider;

    public boolean supportsThingType(ThingTypeUID thingTypeUID) {
        return BoseSoundTouchBindingConstants.SUPPORTED_THING_TYPES_UIDS.contains(thingTypeUID);
    }

    protected ThingHandler createHandler(Thing thing) {
        Storage storage = this.storageService.getStorage(thing.getUID().toString(), ContentItem.class.getClassLoader());
        BoseSoundTouchHandler handler = new BoseSoundTouchHandler(thing, new PresetContainer((Storage<ContentItem>)storage), this.stateOptionProvider);
        return handler;
    }

    @Reference
    protected void setStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unsetStorageService(StorageService storageService) {
        this.storageService = null;
    }

    @Reference
    protected void setPresetChannelTypeProvider(BoseStateDescriptionOptionProvider stateOptionProvider) {
        this.stateOptionProvider = stateOptionProvider;
    }

    protected void unsetPresetChannelTypeProvider(BoseStateDescriptionOptionProvider stateOptionProvider) {
        this.stateOptionProvider = null;
    }
}

