/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bosesoundtouch.internal;

import com.google.gson.annotations.Expose;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.OperationModeType;
import org.eclipse.smarthome.core.types.StateOption;

public class ContentItem {
    private String source = "";
    private String sourceAccount = null;
    private String location = null;
    private boolean presetable = false;
    private String itemName = null;
    private int presetID = 0;
    private String containerArt = null;
    @Expose
    private final Map<String, String> additionalAttributes = new HashMap<String, String>();

    public boolean isPreset() {
        if (this.presetable) {
            return this.presetID > 0;
        }
        return false;
    }

    public boolean isValid() {
        if (this.getOperationMode() == OperationModeType.STANDBY) {
            return true;
        }
        return this.itemName != null && this.source != null && !this.itemName.isEmpty() && !this.source.isEmpty();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ContentItem) {
            ContentItem other = (ContentItem)obj;
            if (!this.isEqual(other.source, this.source)) {
                return false;
            }
            if (!this.isEqual(other.sourceAccount, this.sourceAccount)) {
                return false;
            }
            if (other.presetable != this.presetable) {
                return false;
            }
            if (!this.isEqual(other.location, this.location)) {
                return false;
            }
            return this.isEqual(other.itemName, this.itemName);
        }
        return super.equals(obj);
    }

    public OperationModeType getOperationMode() {
        OperationModeType operationMode = OperationModeType.OTHER;
        if (this.source == null || this.source.equals("")) {
            return OperationModeType.OTHER;
        }
        if (this.source.contains("PRODUCT")) {
            if (this.sourceAccount.contains("TV")) {
                operationMode = OperationModeType.TV;
            }
            if (this.sourceAccount.contains("HDMI")) {
                operationMode = OperationModeType.HDMI1;
            }
            return operationMode;
        }
        try {
            operationMode = OperationModeType.valueOf(this.source);
            return operationMode;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return OperationModeType.OTHER;
        }
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setSourceAccount(String sourceAccount) {
        this.sourceAccount = sourceAccount;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public void setAdditionalAttribute(String name, String value) {
        this.additionalAttributes.put(name, value);
    }

    public void setPresetable(boolean presetable) {
        this.presetable = presetable;
    }

    public void setPresetID(int presetID) {
        this.presetID = presetID;
    }

    public void setContainerArt(String containerArt) {
        this.containerArt = containerArt;
    }

    public String getSource() {
        return this.source;
    }

    public String getSourceAccount() {
        return this.sourceAccount;
    }

    public String getLocation() {
        return this.location;
    }

    public String getItemName() {
        return this.itemName;
    }

    public boolean isPresetable() {
        return this.presetable;
    }

    public int getPresetID() {
        return this.presetID;
    }

    public String getContainerArt() {
        return this.containerArt;
    }

    public String generateXML() {
        String xml;
        switch (this.getOperationMode()) {
            case BLUETOOTH: {
                xml = "<ContentItem source=\"BLUETOOTH\"></ContentItem>";
                break;
            }
            case AUX: 
            case AUX1: 
            case AUX2: 
            case AUX3: {
                xml = "<ContentItem source=\"AUX\" sourceAccount=\"" + this.sourceAccount + "\"></ContentItem>";
                break;
            }
            case TV: {
                xml = "<ContentItem source=\"PRODUCT\" sourceAccount=\"TV\" isPresetable=\"false\" />";
                break;
            }
            case HDMI1: {
                xml = "<ContentItem source=\"PRODUCT\" sourceAccount=\"HDMI_1\" isPresetable=\"false\" />";
                break;
            }
            default: {
                StringBuilder sbXml = new StringBuilder("<ContentItem");
                if (this.source != null) {
                    sbXml.append(" source=\"").append(StringEscapeUtils.escapeXml((String)this.source)).append("\"");
                }
                if (this.location != null) {
                    sbXml.append(" location=\"").append(StringEscapeUtils.escapeXml((String)this.location)).append("\"");
                }
                if (this.sourceAccount != null) {
                    sbXml.append(" sourceAccount=\"").append(StringEscapeUtils.escapeXml((String)this.sourceAccount)).append("\"");
                }
                sbXml.append(" isPresetable=\"").append(this.presetable).append("\"");
                for (Map.Entry<String, String> aae : this.additionalAttributes.entrySet()) {
                    sbXml.append(" ").append(aae.getKey()).append("=\"").append(StringEscapeUtils.escapeXml((String)aae.getValue())).append("\"");
                }
                sbXml.append(">");
                if (this.itemName != null) {
                    sbXml.append("<itemName>").append(this.itemName).append("</itemName>");
                }
                if (this.containerArt != null) {
                    sbXml.append("<containerArt>").append(this.containerArt).append("</containerArt>");
                }
                sbXml.append("</ContentItem>");
                xml = sbXml.toString();
            }
        }
        return xml;
    }

    public StateOption toStateOption() {
        String stateOptionLabel = String.valueOf(String.valueOf(this.presetID)) + ": " + this.itemName;
        return new StateOption(String.valueOf(this.presetID), stateOptionLabel);
    }

    public String toString() {
        return this.itemName;
    }

    private boolean isEqual(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }
}

