/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.fsinternetradio.internal.radio;

import java.io.IOException;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.smarthome.binding.fsinternetradio.internal.radio.FrontierSiliconRadioApiResult;
import org.eclipse.smarthome.binding.fsinternetradio.internal.radio.FrontierSiliconRadioConnection;

public class FrontierSiliconRadio {
    private final FrontierSiliconRadioConnection conn;
    private int currentVolume = 0;

    public FrontierSiliconRadio(String hostname, int port, String pin, HttpClient httpClient) {
        this.conn = new FrontierSiliconRadioConnection(hostname, port, pin, httpClient);
    }

    public boolean isLoggedIn() {
        return this.conn.isLoggedIn();
    }

    public boolean login() throws IOException {
        return this.conn.doLogin();
    }

    public boolean getPower() throws IOException {
        FrontierSiliconRadioApiResult result = this.conn.doRequest("GET/netRemote.sys.power");
        return result.getValueU8AsBoolean();
    }

    public void setPower(boolean powerOn) throws IOException {
        String params = "value=" + (powerOn ? "1" : "0");
        this.conn.doRequest("SET/netRemote.sys.power", params);
    }

    public int getVolumeAbsolute() throws IOException {
        FrontierSiliconRadioApiResult result = this.conn.doRequest("GET/netRemote.sys.audio.volume");
        this.currentVolume = result.getValueU8AsInt();
        return this.currentVolume;
    }

    public int getVolumePercent() throws IOException {
        FrontierSiliconRadioApiResult result = this.conn.doRequest("GET/netRemote.sys.audio.volume");
        this.currentVolume = result.getValueU8AsInt();
        return this.currentVolume * 100 / 32;
    }

    public void setVolumeAbsolute(int volume) throws IOException {
        int newVolume = volume < 0 ? 0 : (volume > 32 ? 32 : volume);
        String params = "value=" + newVolume;
        this.conn.doRequest("SET/netRemote.sys.audio.volume", params);
        this.currentVolume = volume;
    }

    public void setVolumePercent(int volume) throws IOException {
        int newVolumeAbsolute = volume * 32 / 100;
        String params = "value=" + newVolumeAbsolute;
        this.conn.doRequest("SET/netRemote.sys.audio.volume", params);
        this.currentVolume = volume;
    }

    public void increaseVolumeAbsolute() throws IOException {
        if (this.currentVolume < 32) {
            this.setVolumeAbsolute(this.currentVolume + 1);
        }
    }

    public void decreaseVolumeAbsolute() throws IOException {
        if (this.currentVolume > 0) {
            this.setVolumeAbsolute(this.currentVolume - 1);
        }
    }

    public int getMode() throws IOException {
        FrontierSiliconRadioApiResult result = this.conn.doRequest("GET/netRemote.sys.mode");
        return result.getValueU32AsInt();
    }

    public void setMode(int mode) throws IOException {
        String params = "value=" + mode;
        this.conn.doRequest("SET/netRemote.sys.mode", params);
    }

    public String getPlayInfoName() throws IOException {
        FrontierSiliconRadioApiResult result = this.conn.doRequest("GET/netRemote.play.info.name");
        return result.getValueC8ArrayAsString();
    }

    public String getPlayInfoText() throws IOException {
        FrontierSiliconRadioApiResult result = this.conn.doRequest("GET/netRemote.play.info.text");
        return result.getValueC8ArrayAsString();
    }

    public void setPreset(Integer presetId) throws IOException {
        this.conn.doRequest("SET/netRemote.nav.state", "value=1");
        this.conn.doRequest("SET/netRemote.nav.action.selectPreset", "value=" + presetId.toString());
        this.conn.doRequest("SET/netRemote.nav.state", "value=0");
    }

    public boolean getMuted() throws IOException {
        FrontierSiliconRadioApiResult result = this.conn.doRequest("GET/netRemote.sys.audio.mute");
        return result.getValueU8AsBoolean();
    }

    public void setMuted(boolean muted) throws IOException {
        String params = "value=" + (muted ? "1" : "0");
        this.conn.doRequest("SET/netRemote.sys.audio.mute", params);
    }
}

