/**
 * Copyright (c) 2014,2019 Contributors to the Eclipse Foundation
 *
 * See the NOTICE file(s) distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0
 *
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.smarthome.binding.homematic.internal.type;

import java.util.Locale;

import org.eclipse.smarthome.binding.homematic.type.HomematicThingTypeExcluder;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.ChannelTypeProvider;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;

/**
 * Extends the ChannelTypeProvider to manually add a ChannelType.
 *
 * @author Gerhard Riegler - Initial contribution
 */
public interface HomematicChannelTypeProvider extends ChannelTypeProvider {

    /**
     * Adds the ChannelType to this provider.
     */
    public void addChannelType(ChannelType channelType);

    /**
     * Use this method to lookup a ChannelType which was generated by the
     * homematic binding. Other than {@link #getChannelType(ChannelTypeUID, Locale)}
     * of this provider, it will return also those {@link ChannelType}s
     * which are excluded by {@link HomematicThingTypeExcluder}
     *
     * @param channelTypeUID
     *            e.g. <i>homematic:HM-WDS40-TH-I-2_0_RSSI_DEVICE</i>
     * @return ChannelType that was added to HomematicChannelTypeProvider, identified
     *         by its config-description-uri<br>
     *         <i>null</i> if no ChannelType with the given UID was added
     *         before
     */
    public ChannelType getInternalChannelType(ChannelTypeUID channelTypeUID);

}
